package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigDao;
import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigLogDao;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigConsumeEntity;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillStockService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("seckillStockService")
public class SeckillStockServiceImpl implements SeckillStockService {
	
	@Autowired
	private DuibaSeckillStockConfigDao    duibaSeckillStockConfigDAO;
	@Autowired
	private DuibaSeckillStockConfigLogDao duibaSeckillStockConfigLogDAO;

	@Override
	public DuibaSeckillStockConfigEntity findStockByUnique(Long skillId, Long appId) {
		Date now = DateUtil.getDayDate(new Date());
		DuibaSeckillStockConfigEntity stock = duibaSeckillStockConfigDAO.findByUnique(skillId, appId);
		if (stock != null) {
			if (now.equals(stock.getDay())) {
				return stock;
			}
			stock.setStock(0);
			return stock;
		} else {
			DuibaSeckillStockConfigEntity sharingStock = duibaSeckillStockConfigDAO.findByUnique(skillId, 0L);
			if (now.equals(sharingStock.getDay())) {
				return sharingStock;
			}
			sharingStock.setStock(0);
			return sharingStock;
		}
	}

	@Override
	public DuibaSeckillStockConfigEntity findStock(Long stockId) {
		return duibaSeckillStockConfigDAO.find(stockId);
	}

	@Override
	public void consumeStock(Long stockId, Long orderId) throws Exception {
		DuibaSeckillStockConfigEntity stock = duibaSeckillStockConfigDAO.findForUpdate(stockId);
		if(Objects.equal(null, stock)){
			throw new Exception("无对应库存");
		}
		Date now = DateUtil.getDayDate(new Date());
		if(!Objects.equal(now.getTime(), stock.getDay().getTime())){//验证有效期
			throw new Exception("库存失效");
		}
		if(stock.getStock()<=0){
			throw new Exception("库存不足");
		}
		
		DuibaSeckillStockConfigConsumeEntity newlog = new DuibaSeckillStockConfigConsumeEntity();
		newlog.setAction(DuibaSeckillStockConfigConsumeEntity.Action_Pay);
		newlog.setStockConfigId(stockId);
		newlog.setQuantity(-1);
		newlog.setBeforeVal(stock.getStock());
		newlog.setAfterVal(stock.getStock()-1);
		newlog.setRelationType(DuibaSeckillStockConfigConsumeEntity.RelationType_Order);
		newlog.setRelationId(orderId);
		//验证消费日志，检测是否重复扣库存，重复会在插入的时候抛异常
		duibaSeckillStockConfigLogDAO.insertConsumeLog(newlog);
		
		int ret = duibaSeckillStockConfigDAO.consumeStock(stockId);
		if (ret <= 0) {
			throw new Exception("库存不足");
		}
	}
}
