package cn.com.duiba.activity.center.biz.service.sign.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.other.DuibaRemainingMoneyDO;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.entity.plugin.ActivityPluginVistEntity;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent.ActivityOrderPluginContext;
import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagCallback.LuckBagFlowWorker;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginVistService;
import cn.com.duiba.activity.center.biz.service.sign.SignFlowInnerService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.dcommons.flowwork.ActivityPluginFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.CenterConfigDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteCenterConfigService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

/** 
 * ClassName:PluginFlowInnerServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月19日 下午5:31:39 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class SignFlowInnerServiceImpl implements SignFlowInnerService {

	private static Logger log = LoggerFactory.getLogger(SignFlowInnerServiceImpl.class);
	@Autowired
	private ActPreStockSerivce actPreStockSerivce;
	@Autowired
	private RemoteStockService remoteStockService;
	@Autowired
	private RemoteItemKeyService remoteItemKeyService;
	@Autowired
	private TimeLimitService timeLimitService;
	@Autowired
	private ItemKeyStockServcie itemKeyStockServcie;
	@Autowired
	private RemoteCenterConfigService remoteCenterConfigService;
	@Autowired
	private RemoteAddrLimitService remoteAddrLimitService;
	@Autowired
	private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
	@Autowired
	private RemoteAppService remoteAppService;
	@Autowired
	private FrequentExchangeLimitService frequentExchangeLimit;
	@Autowired
	private RemoteActivityOrderService remoteActivityOrderService;
	@Autowired
	private LuckBagFlowWorker luckBagFlowWorker;
	@Autowired
	private ActivityPluginFlowworkService activityPluginFlowworkService;
	@Autowired
	private ActivityPluginVistService activityPluginVistService;
	@Autowired
	private ConsumerActivityLimitService consumerActivityLimitService;
	
	@Override
	public ActivityPrizeOptionDto randomPrize(Long activityId,
			String activityType, List<ActivityPrizeOptionDto> options) {
		double totalRate = 0;
		List<ActivityPrizeOptionDto> validOptions = Lists.newArrayList();
		for(ActivityPrizeOptionDto option : options){
			if(StringUtils.isNotBlank(option.getRate()) && Double.valueOf(option.getRate()) > 0.00001){
				totalRate = totalRate + Double.valueOf(option.getRate());
				validOptions.add(option);
			}
		}
		//奖项概率超过100 时 默认出福袋
		if(totalRate > 100){
			LogUtil.logTodayKan("奖项概率和超过100%,duibaActivityId=" + activityId + ",activityType=" + activityType);
			return awardThanks(activityId,activityType);
		}
		// 随机排序奖项List
		if (options.size() > 1) {
			Collections.shuffle(options);
		}
		
		// 中奖的随机数(0.0000000000000000 到100.0000000000000000)之间的随机数
		double randomNumber = Math.random() * 100;
		double temp = 0.0;
		// 中奖奖项
		ActivityPrizeOptionDto winOption = null;
		for (ActivityPrizeOptionDto option : validOptions) {
			temp += Double.valueOf(option.getRate()).doubleValue();
			if (randomNumber <= temp) {
				winOption = option;
				break;
			}
		}
		if(winOption == null){
			LogUtil.logTodayKan("出奖异常,duibaActivityId=" + activityId + ",activityType=" + activityType);
			return awardThanks(activityId,activityType);
		}
		LogUtil.logTodayKan("awardOptionLuck    =====>  中奖" + activityId + ",activityType=" + winOption.getPrizeType());
		return winOption;
	}

	@Override
	public ActivityPrizeOptionDto awardThanks(Long activityId,
			String activityType) {
		ActivityPrizeOptionDto option = new ActivityPrizeOptionDto();
		option.setActivityId(activityId);
		option.setActivityType(activityType);
		option.setPrizeType(ActivityPrizeOptionDto.Prize_Type_Thanks);
		option.setPrizeName("谢谢参与");
		return option;
	}

	@Override
	public ActivityPrizeOptionDto winOptionCheck(ActivityOrderDto order,
			ActivityPrizeOptionDto winOption,
			List<ActivityPrizeOptionDto> options) {
		//验证奖项能否被抽中
		boolean optionCheck = validOptionCheck(order, winOption);
		//商品本身验证
		boolean itemCheck = validItemKeyCheck(order,winOption,optionCheck);
		if(!itemCheck){
			LogUtil.logTodayKan("winOptionCheck 商品本身验证失败 winOption===>"+JSONObject.toJSONString(winOption));
		    winOption = awardThanks(order.getDuibaActivityId(),order.getActivityType());
			LogUtil.logTodayKan("winOptionCheck    =====>商品降级为  谢谢参与"+JSONObject.toJSONString(winOption));
			return winOption;
		}else{
			return winOption;
		}
	}

	private boolean validOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto prize) {
		//谢谢参与不再验证
		if(prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
			return true;
		}
		if(prize.getMinComein() != null){
			//保底人数校验
			ActivityPluginVistEntity enty = activityPluginVistService.findByActivityIdAndType(order.getDuibaActivityId(), ActivityPluginVistEntity.TYPE_SIGN);
			if(enty.getVisitTimes() < prize.getMinComein()){
				return false;
			}
		}
		//奖项剩余个数验证
		Long stockId = prize.getStockId();
		DubboResult<Long> stockNum = remoteStockService.find(stockId);
		if(!stockNum.isSuccess() || null == stockNum.getResult() || stockNum.getResult() <= 0){
			return false;
		}
		Integer limintCount = consumerActivityLimitService.findConsumerWinOptionNum(order.getConsumerId(), order.getDuibaActivityId(), ActivityOrderDto.TypeSign + order.getActivityOptionId());
		if(limintCount == null){
			limintCount = 0;
		}
		return !(prize.getWinLimit() != null && prize.getWinLimit() > 0 && prize.getWinLimit() <= limintCount);
	}

	@Override
	public boolean validItemKeyCheck(ActivityOrderDto order,
			ActivityPrizeOptionDto prize, boolean check) {
		if(!check){
			return false;
		}
		//谢谢参与不再验证
		if(prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
			return true;
		}
		ItemKey itemKey = remoteItemKeyService.getItemKeyIncludeDeleted(prize.getItemId(), prize.getAppItemId(), order.getAppId());
		if(itemKey == null){
			LogUtil.logTodayKan("validItemKeyCheck    =====>itemKey ==null");
			return false;
		}
		// 开发者仓库删除验证(开发者活动话费,QB,支付宝可能没在他库里不验证)
		if (!ItemDO.TypeAlipay.equals(itemKey.getItemType())&&!ItemDO.TypePhonebill.equals(itemKey.getItemType())&&!ItemDO.TypeQB.equals(itemKey.getItemType())){
			if (itemKey.getAppItem() != null && itemKey.getAppItem().getDeleted()) {
				LogUtil.logTodayKan("validItemKeyCheck    =====> 开发者仓库删除验证(开发者活动话费,QB,支付宝可能没在他库里不验证)");
				return false;
			}
		}
		//兑吧商品禁用或删除
		if(itemKey.getItem() != null && (!itemKey.getItem().getEnable() || itemKey.getItem().getDeleted())){
			LogUtil.logTodayKan("validItemKeyCheck    =====> 兑吧商品禁用或删除");
			return false;
		}
		// 限时，限量，会员等级限制，兑换限制，日期限制等有限制的，都不中奖
		if(null != itemKey.getItem() && timeLimitService.isLimitItem(itemKey.getItem())){
			LogUtil.logTodayKan("validItemKeyCheck    =====> 限时，限量，会员等级限制，兑换限制，日期限制等有限制的，都不中奖");
			return false;
		}
		//APP兑换限制只能测试专用商品中奖
		if (!itemKey.getApp().isAppSwitch(AppDO.SwitchCloseAppTradingLimit)) {
			if (null != itemKey.getItem() && itemKey.getItem().getType().equals(ItemDO.TypeCoupon)) {
				if (!itemKey.getItem().getId().equals(191l)) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> APP兑换限制只能测试专用商品中奖");
					return false;
				}
			} else {
				return false;
			}
		}
		//奖项库存验证
		// 奖项总库存验证
		if(prize.getPrizeType().equals(ItemDO.TypeObject) 
				|| prize.getPrizeType().equals(ItemDO.TypeCoupon)
				|| prize.getPrizeType().equals(ItemDO.TypeVirtual)){
			if(itemKeyStockServcie.findRemaining(itemKey) <= 0){
				LogUtil.logTodayKan("validItemKeyCheck    =====> 奖项总库存验证");
				return false;
			}
		}
		// 优惠券批次校验
		if(!itemKeyStockServcie.couponBatchCheck(itemKey)){
			LogUtil.logTodayKan("validItemKeyCheck    =====> 优惠券批次校验_" +JSONObject.toJSONString(itemKey));
			return false;
		}
		// 失效验证
		if (itemKey.getAppItem()!=null && AppItemDO.SubStatusExpired.equals(itemKey.getAppItem())){
			LogUtil.logTodayKan("validItemKeyCheck    =====> 失效验证_" +JSONObject.toJSONString(itemKey));
			return false;
		}
		// 实物自动下架失效过期验证，自动关闭
		if (ItemDO.TypeObject.equals(itemKey.getItemType())) {
			if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()){
				if(itemKey.getItem().getValidEndDate()!=null && new Date().after(itemKey.getItem().getValidEndDate())){
					LogUtil.logTodayKan("validItemKeyCheck    =====> 实物自动下架失效过期验证，自动关闭");
					return false;
				}
				if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> 实物自动下架失效过期验证，自动关闭1");
					return false;
				}
			}else if(itemKey.isSelfAppItemMode()){
				if(itemKey.getAppItem().getValidEndDate()!=null && new Date().after(itemKey.getAppItem().getValidEndDate())){
					LogUtil.logTodayKan("validItemKeyCheck    =====> 实物自动下架失效过期验证，自动关闭2");
					return false;
				}
				if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> 实物自动下架失效过期验证，自动关闭3");
					return false;
				}
			}
		}
		// 虚拟商品校验
		if (ItemDO.TypeVirtual.equals(itemKey.getItemType())) {
			if (StringUtils.isBlank(itemKey.getApp().getVirtualExchangeUrl())) {
				LogUtil.logTodayKan("validItemKeyCheck    =====> 虚拟商品校验");
				return false;
			} else {
				if (null == itemKey.getAppItem() || itemKey.getAppItem().getDeleted()) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> 虚拟商品校验1");
					return false;
				}
				// 自动关闭时间验证
				if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> 虚拟商品校验2");
					return false;
				}
				PriceDegree priceDegree = new PriceDegree(itemKey.getAppItem().getCustomPrice());
				if (!priceDegree.isDegreeExist(prize.getFacePrice())) {
					LogUtil.logTodayKan("validItemKeyCheck    =====> 虚拟商品校验3");
					return false;
				}
			}
		}
		//地域限制验证
		List<ItemKeyVO> itemKeyVOs = Lists.newArrayList(new ItemKeyVO(itemKey));
		itemKeyVOs = remoteAddrLimitService.mobileIndexAddrLimitFilter(itemKeyVOs, order.getIp());
		if(itemKeyVOs.isEmpty()){
			LogUtil.logTodayKan("validItemKeyCheck    =====> 地域限制验证");
			return false;
		}
		// 开发者余额，日，月预算验证
		Integer actualPrice = null;
		if (ItemDO.TypeAlipay.equals(itemKey.getItemType()) || ItemDO.TypePhonebill.equals(itemKey.getItemType()) || ItemDO.TypeQB.equals(itemKey.getItemType())) {
			actualPrice = Integer.valueOf(prize.getFacePrice());
		} else if (ItemDO.TypeObject.equals(itemKey.getItemType()) || ItemDO.TypeCoupon.equals(itemKey.getItemType())) {
			actualPrice = calculateNormalActualPrice(itemKey,null);
		}
		if (actualPrice != null && actualPrice > 0)
		{
			if (ItemDO.TypeAlipay.equals(itemKey.getItemType()) || ItemDO.TypePhonebill.equals(itemKey.getItemType()) || ItemDO.TypeQB.equals(itemKey.getItemType())){
				DuibaRemainingMoneyDO duibaM =duibaRemainingMoneyDAO.findDuibaAccountMoney();
				Long money=duibaM.getMoney();
				if (money < actualPrice)
				{
					LogUtil.logTodayKan("validItemKeyCheck    =====> 开发者余额，日，月预算验证1");
					return false;
				}
			}
		}
		//开发者日，月预算 校验
		if (actualPrice != null && actualPrice > 0) {
			if (!isDayBudgetEnough(itemKey)) {
				LogUtil.logTodayKan("validItemKeyCheck    =====> 开发者余额，日，月预算验证2");
				return false;
			} else if (!isMonthBudgetEnough(itemKey)) {
				LogUtil.logTodayKan("validItemKeyCheck    =====> 开发者余额，日，月预算验证3");
				return false;
			} else {
				AppDO app = remoteAppService.find(order.getAppId());
				DuibaRemainingMoneyDO money = duibaRemainingMoneyDAO.findByDeveloperId(app.getDeveloperId());
				if(money !=null){
					if (actualPrice > money.getMoney()) {
						LogUtil.logTodayKan("validItemKeyCheck    =====> 开发者余额，日，月预算验证4");
						return false;
					}
				}
			}
		}
		return true;
	}

	@Override
	public void doWinPrize(ActivityOrderDto order,
			ActivityPrizeOptionDto winOption,
			List<ActivityPrizeOptionDto> options, String ip, String ua,
			String os, SignConfigDto signDto) throws Exception {
		
		Long couponId = null;
		ActivityOrderPluginContext context = new ActivityOrderPluginContext();
		try{
			if (winOption.getId() != null) {
				LogUtil.logTodayKan("===============》    扣库存  开始");
				DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
				Object obj = context.getAttribute("couponId");
				if (null != obj) {
					couponId = (Long) obj;
				}
			}
			// 更新订单中奖信息
			DubboResult<Boolean> result = remoteActivityOrderService.addCreditsSuccess(order.getOrderNum(),winOption.getId(),winOption.getDescription(),
					winOption.getPrizeType(),winOption.getFacePrice(),winOption.getAppItemId(),
					winOption.getItemId(),winOption.getgId(),winOption.getgType(),couponId);
			if(!result.isSuccess()){
				LogUtil.logTodayKan("===============》    更新订单中奖信息  失败");
				throw new Exception("更新抽奖订失败");
			}else{
				LogUtil.logTodayKan("===============》    winOption.getPrizeName()" +winOption.getPrizeName());
			}
			// 记录用户奖项中奖次数
			if (winOption.getWinLimit() != null && winOption.getId() != null) {
			    LogUtil.logTodayKan("===============》   1. 记录用户奖项中奖次数");
				consumerActivityLimitService.incrConsumerWinOptionNum(order.getConsumerId(), order.getDuibaActivityId(), ActivityOrderDto.TypeSign+order.getActivityOptionId());
			}
		}catch(Exception e){
			LogUtil.logTodayKan("===============》    回滚库存");
			DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
			LogUtil.logTodayKan("className: "+this.getClass().getName()+" method: doWinPrize",e);
			throw e;
		}finally{
			// 记录用户奖项访问次数
		    LogUtil.logTodayKan("===============》   2. 记录用户奖项访问次数");
			activityPluginVistService.updateActivityPluginInfo(order.getDuibaActivityId(), ActivityPluginVistEntity.TYPE_SIGN);
		}
		LogUtil.logTodayKan("===============》   2. 记录用户奖项访问次数，完成");
		//设置 领证状态未待领奖 状态
		remoteActivityOrderService.exchangeStatusToWait(order.getOrderNum());
		LogUtil.logTodayKan("===============》   3. 设置 领证状态未待领奖 状态");
		// 用户兑换记录
		if (!winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
		    LogUtil.logTodayKan("===============》   4. 创建兑换记录");
			//创建兑换记录
			activityPluginFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(),order.getOrderNum(), ActivityOrderDto.TypeSign,winOption.getPrizeType());
		}
		
		//优惠券,虚拟商品领奖验证
		if(winOption.getPrizeType().equals(ItemDO.TypeCoupon)||winOption.getPrizeType().equals(ItemDO.TypeVirtual)){
			try{
				LogUtil.logTodayKan("===============》    优惠券自动领奖");
				activityPluginFlowworkService.autoTakePrize(order.getOrderNum(),order.getConsumerId(), order.getAppId(),ip, ua);
			}catch(Exception e){
				LogUtil.logTodayKan("优惠券领奖异常",e);
				LogUtil.logTodayKan("===============》  5. 优惠券领奖异常");
			}
		}
		LogUtil.logTodayKan("===============》   6. 中奖结束了");
	}

	
	/**
	 * 计算普通商品的实际价格
	 * （普通商品为不包含话费、流量这两个需要查询费用表的商品）
	 * @param key
	 * @param degree
	 * @return
	 * @throws Exception
	 */
	private Integer calculateNormalActualPrice(ItemKey key, String degree) {
		if (key.isItemMode() || key.isDuibaAppItemMode()) {
			if (key.getItemType().equals(ItemDO.TypeCoupon) || key.getItemType().equals(ItemDO.TypeObject)) {
				if (degree == null) {
					return key.getItem().getActualPrice();
				} else {
					throw new RuntimeException("券或者实物类商品不用传档位信息！");
				}
			}else if(key.getItem().getType().equals(ItemDO.TypePhonebill) || key.getItemType().equals(ItemDO.TypePhoneflow) || key.getItemType().equals(ItemDO.TypePhonebillDingzhi)){
				throw new RuntimeException("话费和流量商品不走这个方法！");
			}else if (key.getItemType().equals(ItemDO.TypeAlipay) || key.getItemType().equals(ItemDO.TypeQB)
					|| key.getItemType().equals(ItemDO.TypeAlipayFast) || key.getItemType().equals(ItemDO.TypeAlipayCode)) {
				if (degree == null) {
					throw new RuntimeException("直充类商品不可以没有档位信息！");
				} else {
					Integer price = Integer.valueOf(degree)*100;
					Integer actualPrice=price;
					CenterConfigDO ccDO = null;
					if(key.getItem().getType().equals(ItemDO.TypeAlipay)){
						ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipayRate);
					}else if(key.getItem().getType().equals(ItemDO.TypeQB)){
						ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeEnlianQbRate);
					}else if(key.getItem().getType().equals(ItemDO.TypeAlipayFast)){
						ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipayfastRate);
					}else if(key.getItem().getType().equals(ItemDO.TypeAlipayCode)){
						ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipaycodeRate);
					}else{
						throw new RuntimeException("没有此商品的费率信息！");
					}
					String rateString = null;
					if (ccDO.getValue() != null) {
						rateString = ccDO.getValue();
					} else {
						rateString = ccDO.getFloatValue().toString();
					}
					BigDecimal ret = new BigDecimal(price).multiply(new BigDecimal(rateString));
					actualPrice=(int)Math.ceil(ret.doubleValue());
					return actualPrice;
				}
			} else {
				throw new RuntimeException("无此商品类型！");
			}
		} else if (key.isSelfAppItemMode()) {
			if (key.getItemType().equals(ItemDO.TypeCoupon) || key.getItemType().equals(ItemDO.TypeObject)) {
				return 0;
			}else if(ItemDO.TypeVirtual.equals(key.getItemType())){
				return 0;
			}else{
				throw new RuntimeException("未知的自有商品类型！");
			}
		}else{
			throw new RuntimeException("无此模式类型！");
		}
	}
	
	/**
	 * 获取最小的价格(不保证100%准确，只是用于展示验证)
	 * @param key
	 * @return
	 */
	private Integer calculateMinActualPrice(ItemKey key) {
		if (key.getItemType().equals(ItemDO.TypeAlipay) || key.getItemType().equals(ItemDO.TypeQB) || key.getItemType().equals(ItemDO.TypeAlipayFast)
				|| key.getItemType().equals(ItemDO.TypeAlipayCode)) {
			PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
			String minDegree = pd.getMinDegreeKey();
			return calculateNormalActualPrice(key, minDegree);
		} else if (key.getItemType().equals(ItemDO.TypePhonebill)||key.getItemType().equals(ItemDO.TypePhoneflow)) {
			return 100;
		} else if (key.getItemType().equals(ItemDO.TypeCoupon) || key.getItemType().equals(ItemDO.TypeObject)) {
			return calculateNormalActualPrice(key,null);
		} else if (key.getItemType().equals(ItemDO.TypePhonebillDingzhi)) {
			return key.getItem().getFacePrice();
		}
		return 0;
	}
	
	/**
	 * 只提供给用户手机端调用 是否月预算足
	 */
	public boolean isMonthBudgetEnough(ItemKey key) {
		AppDO app = key.getApp();
		if (key.isItemMode() || key.isDuibaAppItemMode()) {
			if (app.getBudget() == null) {
				return true;
			}
			if (app.getBudgetRemain() == null) {
				throw new RuntimeException("月预算余额数据错误！");
			}
			if (ItemDO.TypeAlipay.equals(key.getItemType()) || ItemDO.TypeQB.equals(key.getItemType()) || ItemDO.TypePhonebill.equals(key.getItemType()) || ItemDO.TypePhoneflow.equals(key.getItemType())) {
				if (app.getBudgetRemain() < calculateMinActualPrice(key)) {
					return false;
				}
			} else {
				//2016年1月19加入加钱购商品月、日预算逻辑
				if(key.getItem().isOpTypeItem(ItemDO.OpTypeIsAmb)){
					Long diffPrice = key.getItem().getActualPrice().longValue()-(key.getItem().getSalePrice()); 
					if(app.getDayBudgetRemain() < diffPrice){
						return false;
					}
				}else {
					if (app.getDayBudgetRemain() < key.getItem().getActualPrice()) {
						return false;
					}
				}
			}
			return true;
		} else if (key.isSelfAppItemMode()) {
			return true;
		}
		throw new RuntimeException("商品不存在！");
	}
	
	/**
	 * 只提供给用户手机端调用 是否日预算足
	 * 根据档位算成实际价格
	 */
	private boolean isDayBudgetEnough(ItemKey key) {
		AppDO app = key.getApp();
		if (key.isItemMode() || key.isDuibaAppItemMode()) {
			if (app.getDayBudget() == null) {
				return true;
			}
			if (app.getDayBudgetRemain() == null) {
				throw new RuntimeException("日预算余额数据错误！");
			}
			if (ItemDO.TypeAlipay.equals(key.getItemType()) || ItemDO.TypeQB.equals(key.getItemType()) || ItemDO.TypeAlipayFast.equals(key.getItemType()) || ItemDO.TypeAlipayCode.equals(key.getItemType())) {
				if (app.getDayBudgetRemain() < calculateMinActualPrice(key)) {
					return false; 
				}
			} else {
				//2016年1月19加入加钱购商品月、日预算逻辑
				if(key.getItem().isOpTypeItem(ItemDO.OpTypeIsAmb)){
					Long diffPrice = key.getItem().getActualPrice().longValue()-(key.getItem().getSalePrice()); 
					if(app.getDayBudgetRemain() < diffPrice){
						return false;
					}
				}else {
					if (app.getDayBudgetRemain() < key.getItem().getActualPrice()) {
						return false;
					}
				}
			}
			return true;
		} else if (key.isSelfAppItemMode()) {
			return true;
		}
		throw new RuntimeException("商品不存在！");
	}
}
