package cn.com.duiba.activity.center.biz.sign.event;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent.ActivityOrderPluginContext;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventListener;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsFailEvent;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsFailEvent.AddCreditsFailListener;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsSuccessEvent.AddCreditsSuccessListener;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

public class SignEventsDispatcher {

	private static Logger log = LoggerFactory.getLogger(SignEventsDispatcher.class);

	private static SignEventsDispatcher dispatcher = new SignEventsDispatcher();

	public static SignEventsDispatcher get() {
		return dispatcher;
	}

	public void dispatchEvent(final DuibaEvent<?> e) {
		if (e instanceof ActivityOrdersEvent) {
		    processActivityOrdersEvent((ActivityOrdersEvent) e);
		}
	}


	private void processActivityOrdersEvent(final ActivityOrdersEvent event) {
		final List<ActivityOrdersEventListener> listeners = SignEventsRegister.get().activityOrderListener;
		if (!listeners.isEmpty()) {
		    ThreadPoolDuibaService.get().submit(new Runnable() {
                public void run() {
        			for (ActivityOrdersEventListener l : new ArrayList<ActivityOrdersEventListener>(listeners)) {
        				try {
        					if (event.getType() == ActivityOrdersEventType.OnOrderCreate) {
        						l.onOrderCreate(event.getData());
        					} else if (event.getType() == ActivityOrdersEventType.OnOrderSuccess) {
        						l.onOrderSuccess(event.getData());
        					} else if (event.getType() == ActivityOrdersEventType.OnOrderFail) {
        						l.onOrderFail(event.getData());
        					}
        				} catch (Exception e) {
        					log.error("processActivityOrderEvent", e);
        				}
        			}
                }
            }, ThreadPoolDuibaService.PriorityNormal);
		}
	}
	
	public void triggerAfterActivityOrderCreate(ActivityOrderDto order) {
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)){
            try {
                p.afterOrderCreate(order);
            } catch (Exception e) {
                log.error(p.getClass().getName()+" process error",e);
            }
        }
    }
	
	public void triggerBeforeActivityOrderComplete(ActivityOrderDto order,ActivityPrizeOptionDto option,ActivityOrderPluginContext context) throws Exception{
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)){
            p.beforeStockComplete(order, option, context);
        }
    }
	
	public void triggerOnActivityOrderCompleteException(ActivityOrderDto order,ActivityPrizeOptionDto option,Exception exception,ActivityOrderPluginContext context){
        for(ActivityOrderSyncEvent p:new ArrayList<ActivityOrderSyncEvent>(SignEventsRegister.get().activityOrderSigns)){
            try{
                p.beforeStockCompleteException(order, option, exception, context);
            } catch(Exception e){
                log.error(p.getClass().getName()+" process error",e);
            }
        }
    }
	
	
	public void dispatchAddCreditsFailEvent(final AddCreditsFailEvent event) {
        if (event.getException() != null) {
            ThreadPoolDuibaService.get().submit(new Runnable() {
                @Override
                public void run() {
                    List<AddCreditsFailListener> listeners = SignEventsRegister.get().addCreditsFailListeners;
                    if (event.getActivityOrder() != null) {
                        for (AddCreditsFailListener l : listeners) {
                            try {
                                l.onAddActivityOrderFail(event.getActivityOrder(), event.getException());
                            } catch (Exception e) {
                                log.error("dispatchAddCreditsFailEvent", e);
                            }
                        }
                    }
                }
            }, ThreadPoolDuibaService.PriorityLow);
        }
    }
	
	public void dispatchAddCreditsSuccessEvent(final ConsumerCreditsSuccessEvent event) {
        ThreadPoolDuibaService.get().submit(new Runnable() {
            @Override
            public void run() {
                List<AddCreditsSuccessListener> listeners = SignEventsRegister.get().addCreditsSuccessListeners;
                if (event.getActivityOrder() != null) {
                    for (AddCreditsSuccessListener l : listeners) {
                        try {
                            l.onAddOrderSuccess(event.getActivityOrder());
                        } catch (Exception e) {
                            log.error("dispatchAddCreditsSuccessEvent", e);
                        }
                    }
                }
            }
        }, ThreadPoolDuibaService.PriorityLow);
    }

}
