package cn.com.duiba.activity.center.biz.sign.event.order;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;

public interface ActivityOrderSyncEvent {

	/**
	 * 创建订单之后
	 * 
	 * 此方法不得抛出异常
	 * 
	 * @param order
	 */
	public void afterOrderCreate(ActivityOrderDto order);

	/**
	 * 抽中奖项后扣库存
	 * 
	 * @param order
	 * @param option
	 * @param request
	 * @param context
	 * @throws Exception
	 */
	public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSignContext context) throws Exception;

	/**
	 * 处理中奖信息失败后，回滚扣库存
	 * 
	 * @param order
	 * @param option
	 * @param exception
	 * @param request
	 * @param context
	 */
	public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSignContext context);

	public static class ActivityOrderSignContext {
		public static final String COUPONID = "couponId";
		private Map<String, Object> attributes = new HashMap<String, Object>();

		public void setAttribute(String key, Object value) {
			attributes.put(key, value);
		}

		public Object getAttribute(String key) {
			return attributes.get(key);
		}

		public void remove(String key) {
			attributes.remove(key);
		}
	}

	
}
