package cn.com.duiba.activity.center.biz.support;

import java.text.SimpleDateFormat;
import java.util.Date;

import cn.com.duiba.wolf.utils.DateUtils;

/**
 * RedisKey 活动中心的所有获取key写到这里，避免key重复
 * 
 * @author houwen
 */
public class RedisKeyFactory {

	public static final String SPACE = "activity-center";

	public static String getConsumerJoinNumTodayKey(Long consumerId, Long operatingActivityId) {
		String today = new SimpleDateFormat("yyy-MM-dd").format(new Date());
		String key = SPACE + "joinNum" + today + "_" + consumerId.toString() + "_" + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerJoinNumForeverKey(Long consumerId, Long operatingActivityId) {
		String key = SPACE + "joinNum" + "_" + consumerId.toString() + "_" + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerFreeNumTodayKey(Long consumerId, Long operatingActivityId) {
		String today = new SimpleDateFormat("yyy-MM-dd").format(new Date());
		String key = SPACE + "freeNum" + today + "_" + consumerId.toString() + "_" + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerFreeNumForeverKey(Long consumerId, Long operatingActivityId) {
		String key = SPACE + "freeNum" + "_" + consumerId.toString() + "_" + operatingActivityId.toString();
		return key;
	}

	public static String getConsumerWinOptionNumKey(Long consumerId, Long operatingActivityId, String optionId) {
		String key = SPACE + "winOptionNum" + "_" + consumerId.toString() + "_" + operatingActivityId.toString() + "_" + optionId;
		return key;
	}
	
	public static String getConsumerTodaySignKey(Long appId, Long consumerId) {
        String key = SPACE + "todaySign" +appId + consumerId.toString() +DateUtils.getDayStr(new Date());
        return key;
    }

	public static String getConsumerJoinNumForeverKeyNoLimit(Long consumerId, Long operatingActivityId) {
        String key = SPACE + "forever" + "_" + consumerId.toString() + "_" + operatingActivityId.toString();
        return key;
    }
}
