/**
 * Project Name:activity-center-biz
 * File Name:CategoryActivityBo.java
 * Package Name:cn.com.duiba.activity.center.biz.bo.activity
 * Date:2016年8月25日下午3:34:15
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.bo.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.service.domain.dataobject.EmbedDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;

/**
 * ClassName:CategoryActivityBo <br/>
 * 关于子页面的各种服务
 * Date:     2016年8月25日 下午3:34:15 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class CategoryActivityBo {
    
    private static final Logger log=LoggerFactory.getLogger(CategoryActivityBo.class);
    @Autowired
    private ActivityCategoryService activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;
    @Autowired
    private OperatingActivityService operatingActivityService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Autowired
    private DuibaHdtoolService duibaHdtoolService;
    @Autowired
    private DuibaQuizzService duibaQuizzService;
    @Autowired
    private DuibaQuestionAnswerService duibaQuestionAnswerService;
    @Autowired
    private DuibaGuessService duibaGuessService;
    @Autowired
    private DuibaNgameService duibaNgameService;
    @Autowired
    private SingleLotteryService singleLotteryService;
    @Autowired
    private AppManualLotteryService appManualLotteryService;
    
    
    public List<CategoryActivityDto> findAllActivitiesByAppCategory(long appId,long categoryId,long consumerId, String ip, String os,
                                                                             String clickUlr,int start,int pageSize){
        List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId,categoryId,start,pageSize);
        List<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
        List<CategoryActivityDto> rs = new ArrayList<CategoryActivityDto>();
        
        Set<Long> operatingActivityIdSet=new HashSet<>();
        
        if (acrs != null && acrs.size() > 0) {
            for (ActivityCategoryRelationEntity acr : acrs) {
                
                CategoryActivityDto dto = new CategoryActivityDto();
                dto.setId(acr.getId());
                dto.setOperatingId(acr.getOperatingActivityId());
                dto.setPayload(acr.getPayload());
                dto.setAppId(appId);
                dto.setCategoryId(categoryId);
                dtos.add(dto);
                operatingActivityIdSet.add(acr.getOperatingActivityId());
            }
            
            List<OperatingActivityDto> activityDtos= operatingActivityService.findAllByIds(new ArrayList<Long>(operatingActivityIdSet));//批量查询opertingActivity
            Map<Long,OperatingActivityDto> map=new HashMap<>();
            for(OperatingActivityDto activityDto:activityDtos){
                map.put(activityDto.getId(),activityDto);
            }
            //获取跳转链接
            for(CategoryActivityDto cat:dtos){
                OperatingActivityDto activity = map.get(cat.getOperatingId());
                cat.setType(activity.getType());
                cat.setActivityId(activity.getActivityId());
                cat.setTitle(activity.getTitle());
                cat.setBanner(activity.getBannerImage());
                cat.setThumb(activity.getSmallImage());
                cat.setLogo(activity.getLogo());
                if(activity==null||activity.getStatus()!=OperatingActivityDto.StatusIntOpen){
                    //this.remoteActivityCategoryBackendService.removeActivityCategoryRelation(activity.getId());
                    continue;
                }
                JSONObject json = new JSONObject();
                String  infoType = this.setImage(cat);
                //应用id
                json.put("app_id",appId);
                //用户id
                json.put("consumer_id",consumerId);
                //登陆状态（未登录：0，登陆：1）
                json.put("login_type",1);
                //细节类型
                json.put("info_type",infoType);
                //细节类型
                json.put("info",activity.getActivityId());
                //ip
                json.put("ip",ip);
                json.put("os", os);
                json.put("domain", clickUlr);
                if(infoType.equals(EmbedDO.InfoType_NGame)){
                    json.put("activity_type", 9);
                    json.put("duiba_activity_id",activity.getActivityId());
                }
                ItemKey key =remoteItemKeyService.getItemKeyIncludeDeleted(null,activity.getAppItemId(),appId);

                ItemKeyVO itemKeyVo = new ItemKeyVO(key);
                if(activity.getCustomCredits() !=null && activity.getCustomCredits() > 0L){
                    cat.setCredits(activity.getCustomCredits());
                }else{
                    cat.setCredits(activity.getCredits());
                }
                cat.setLink(itemKeyVo.getLink());
                cat.setSt_info(json.toJSONString());
                rs.add(cat);
            } 
        }
        return rs;
    }
    /**
     * 查询operating活动的各种图片字段 <br/>
     * 不同活动的图片字段存储在不同的表中,根据operatingActivityId,查出type与activityId，然后分别去对应的表中查询此字段<br/>
     * 目前只是活动子页面用到此方法,涉及到部分活动,故只查询了涉及到的活动，不涉及的懒的弄了<br/>
     * 涉及到活动如下：<br/>
     * 兑吧活动 <br/>
     * 活动名称 smallImage字段所在表 <br/>
     * 兑吧单品抽奖 duiba_single_lottery <br/>
     * 兑吧活动工具 duiba_hdtool <br/>
     * 兑吧测试题 duiba_quizz <br/>
     * 兑吧答题 duiba_question_answer <br/>
     * 兑吧竞猜 duiba_guess <br/>
     * 兑吧游戏平台 duiba_ngame <br/>
     * 自有活动 <br/>
     * 自有单品抽奖 app_single_lottery <br/>
     * 老大转盘 operating_activity <br/>
     * 手动开奖 app_manual_lottery <br/>
     * 自有活动工具(摇一摇，刮刮卡，摇奖机) operating_activity<br/>
     *
     * @author wubo
     * @param operatingActivity
     * @return
     * @since JDK 1.6
     */
    public String setImage(CategoryActivityDto activity) {
        Integer type = activity.getType();
        Long activityId = activity.getActivityId();
        String infotype=EmbedDO.InfoType_Items;
        if (type == OperatingActivityDto.TypeTurnTable) {
            infotype=EmbedDO.InfoType_Turntable;
        } else if (isAppHdtool(activity)) {
            infotype=EmbedDO.InfoType_AppManualLottery;
        } else if (type == OperatingActivityDto.TypeDuibaSingleLottery) {// 其余活动就 只能一个一个根据type判断类型，然后去对应的表中拿字段
            DuibaSingleLotteryDto entity = this.duibaSingleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            //这b没有推荐图
            infotype=EmbedDO.InfoType_SingleLottery;
        } else if (activity.isHdTool() && activityId != null) {
            DuibaHdtoolDto entity = this.duibaHdtoolService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_Hdtool;
        } else if (type == OperatingActivityDto.TypeDuibaQuizz) {
            DuibaQuizzDto entity = this.duibaQuizzService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_Quizz;
        } else if (type == OperatingActivityDto.TypeDuibaQuestionAnswer) {
            DuibaQuestionAnswerDto entity = this.duibaQuestionAnswerService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_Question;
        } else if (type == OperatingActivityDto.TypeDuibaGuess) {
            DuibaGuessDto entity = this.duibaGuessService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_Guess;
        } else if (type == OperatingActivityDto.TypeDuibaNgame) {
            DuibaNgameDto entity = this.duibaNgameService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_NGame;
        } else if (type == OperatingActivityDto.TypeAppSingleLottery) {
            AppSingleLotteryDto entity = this.singleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
//            activity.setWhitethumb(entity.getWhiteImage());
//            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_AppManualLottery;
        } else if (type == OperatingActivityDto.TypeAppManualLottery) {
            AppManualLotteryDto entity = this.appManualLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
//            activity.setWhitethumb(entity.getWhiteImage());
//            activity.setRecommendImage(entity.getRecommendImage());
            infotype=EmbedDO.InfoType_AppManualLottery;
        } else {
            // 其余活动暂不考虑
        }
        return infotype;
    }

    /**
     * isAppHdtool:判断是否是自有的活动工具 <br/>
     * 自有活动工具属性信息存储在operatingactivity表中,activityId为null 兑吧活动工具属性信息存储在活动工具表中，operatingactivity.activityId关联活动工具表的id
     *
     * @author wubo
     * @param CategoryActivityDto(参数类中必须包含type字段)
     * @return
     * @since JDK 1.6
     */
    public boolean isAppHdtool(CategoryActivityDto oa) {
        boolean rs = false;
        if (oa.isHdTool()) {
            if (oa.getActivityId() == null) {
                rs = true;
            }
        }
        return rs;
    }
}

