package cn.com.duiba.activity.center.biz.core;

import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 数据库连接池检查报警,当连接池数目过满时打印报警日志
 * Created by wenqi.huang on 16/6/30.
 */
@Component
public class DatabaseHelper implements ApplicationContextAware,InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);

    private Map<String,BasicDataSource> dataSourceMap;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        dataSourceMap = applicationContext.getBeansOfType(BasicDataSource.class);
    }

    @Override
    public void afterPropertiesSet() throws Exception {

        Thread dataSourceConnPoolPrintThread = new Thread(){

            public void run(){
                int i=0;
                while(true){
                    for(Map.Entry<String, BasicDataSource> entry : dataSourceMap.entrySet()){
                        BasicDataSource ds = entry.getValue();
                        if(!ds.isClosed()) {
                            int numIdleConnections = ds.getNumIdle();//池中有多少个空闲连接，它们可以被checkout
                            int numConnections = ds.getNumActive();//池中有多少个连接,等于idle+busy
                            int numBusyConnections = numConnections - numIdleConnections;////表明池中有多少个被checkout的连接
                            int max = ds.getMaxTotal();
                            if (numConnections >= max - 3 && numBusyConnections >= numConnections - 3) {
                                log.error("datasource [" + entry.getKey() + "]'s connectionPool is too full,max:" + max + ",busy:" + numBusyConnections + ",idle:" + numIdleConnections);
                            }
                        }

                        i++;
                    }
                    try {
                        Thread.sleep(20000);
                    } catch (InterruptedException e) {
                        log.error("error:",e);
                        break;
                    }
                    //没隔20S检查一次,看连接数是否正常
                    if(Thread.currentThread().isInterrupted()){
                        break;
                    }
                }
            }

        };

        dataSourceConnPoolPrintThread.start();
    }
}
