package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOptionsDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOptionsEntity;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionAnswerOptionsDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerOptionsDao {

	@Override
	public List<DuibaQuestionAnswerOptionsEntity> findOptionsByQuestionId(Long duibaQuestionId) {
		return selectList("findOptionsByQuestionId", duibaQuestionId);
	}

	public List<DuibaQuestionAnswerOptionsEntity> findOptionsByQuestionIds(List<Long> duibaQuestionIds){
		if(duibaQuestionIds == null || duibaQuestionIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String,Object> params = new HashMap<>();
		params.put("duibaQuestionIds", duibaQuestionIds);
		return selectList("findOptionsByQuestionIds", params);
	}

	@Override
	public DuibaQuestionAnswerOptionsEntity find(Long id) {
		return selectOne("find", id);
	}

	@Override
	public int delete(List<Long> ids) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("ids", ids);
		return update("delete", params);
	}

	@Override
	public void insert(DuibaQuestionAnswerOptionsEntity questionAnswerOptionsDO) {
		insert("insert",questionAnswerOptionsDO);
	}

	@Override
	public int update(DuibaQuestionAnswerOptionsEntity questionAnswerOptionsDO) {
		return update("update",questionAnswerOptionsDO);
	}

	@Override
	public DuibaQuestionAnswerOptionsEntity findById(Long id) {
		return selectOne("findById", id);
	}

	@Override
	public List<DuibaQuestionAnswerOptionsEntity> findByIds(List<Long> ids) {
		if(ids == null || ids.isEmpty()){
			return Collections.emptyList();
		}
		Map<String,Object> map = new HashMap<>();
		map.put("ids", ids);
		return selectList("findByIds", map);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
