package cn.com.duiba.activity.center.biz.dao.guess.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.entity.guess.GuessOrdersEntity;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

/**
 * Created by yansen on 16/7/18.
 */
@Repository
public class GuessOrdersSimpleDaoImpl extends ActivityBaseDao implements GuessOrdersSimpleDao {
	
	@Override
	public void insert(GuessOrdersEntity entity, Long id){
		Map<String, Object> paramMap = getTbSuffixParamsMap(entity.getConsumerId());
		entity.setId(id);
        paramMap.put("mirror", entity);
        insert("insert", paramMap);
	}

    /**
     * 查询用户参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("findConsumerLimitNumber", paramMap);
    }

    /**
     * 查询用户在时间段内参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("findConsumerLimitNumberByDate", paramMap);
    }

    /**
     * 查询用户免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("findConsumerFreeNumber", paramMap);
    }

    /**
     * 查询用户在时间段内免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("findConsumerFreeNumberByDate", paramMap);
    }


    /**
     * 根据ID查询订单
     */
    public GuessOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    /**
     * 根据活动订单ID集合查询订单信息
     */
    public List<GuessOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("ids", ids);
        return selectList("findByIds", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findWinOrders(Long consumerId, Long duibaGuessId) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("consumerId", consumerId);
        return selectList("findWinOrders", paramMap);
    }

    @Override
    public List<GuessOrdersEntity> findGuessOrders(Long consumerId,Long duibaGuessId) {
        Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("duibaGuessId", duibaGuessId);
        paramMap.put("consumerId", consumerId);
        return selectList("findGuessOrders", paramMap);
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.GUESS_CON;
    }
}
