package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolSkinDataDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * ClassName:HdtoolSkinDataDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月1日 下午1:52:33 <br/>
 * @author   zp
 * @version
 * @since    JDK 1.6
 * @see
 */
@Repository
public class HdtoolSkinDataDaoImpl extends ActivityBaseDao implements HdtoolSkinDataDao {

    @Override
    public void insert(HdtoolSkinEntity hdtoolSkinEntity) {
        insert("insert",hdtoolSkinEntity);
    }

    @Override
    public int updateDataJson(Long hdtoolId,String type,String dataJson) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        map.put("dataJson", dataJson);
        return update("updateDataJson", map);
    }
    
    @Override
    public int updateDataJsonAppId(Long hdtoolId,String type,String dataJson, Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        map.put("dataJson", dataJson);
        map.put("appId", appId);
        return update("updateDataJsonAppId", map);
    }

    @Override
    public HdtoolSkinEntity selectByHdtoolIdAndType(Long hdtoolId, String type) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        return selectOne("selectByHdtoolIdAndType", map);
    }
    
    @Override
    public HdtoolSkinEntity selectByHdtoolIdTypeAndAppId(Long hdtoolId, String type, Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        map.put("appId", appId);
        return selectOne("selectByHdtoolIdTypeAndAppId", map);
    }

    @Override
    public String selectJsonByHdtoolIdAndType(Long hdtoolId, String type) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        return selectOne("selectJsonByHdtoolIdAndType", map);
    }
    
    @Override
    public String selectJsonByHdtoolIdTypeAndAppId(Long hdtoolId, String type, Long appId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("hdtoolId", hdtoolId);
        map.put("type", type);
        map.put("appId", appId);
        return selectOne("selectJsonByHdtoolIdTypeAndAppId", map);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }

}
