/**
 * Project Name:activity-center-biz
 * File Name:RemoteTodayRobConfigServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.rob
 * Date:2016年7月25日下午3:22:38
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.rob;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.RemoteTodayRobConfigService;
import cn.com.duiba.activity.center.biz.bo.activity.ActivityBo;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteTodayRobConfigServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午3:22:38 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteTodayRobConfigServiceImpl implements RemoteTodayRobConfigService{
    
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private ActivityBo activityBo;

    @Override
    public DubboResult<TodayRobConfigDto> find(Long configId) {
        return DubboResult.successResult(todayRobConfigService.find(configId));
    }

    @Override
    public DubboResult<Long> saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto) {
        Long id = todayRobConfigService.saveOrUpdateTodayRobConfig(todayRobConfigDto);
        return DubboResult.successResult(id);
    }

    @Override
    public DubboResult<List<TodayRobConfigDto>> findTodayRobConfigPage(Map<String, Object> params) {
        return DubboResult.successResult(todayRobConfigService.findTodayRobConfigPage(params));
    }

    @Override
    public DubboResult<Integer> findTodayRobConfigCount(Map<String, Object> params) {
        return DubboResult.successResult(todayRobConfigService.findTodayRobConfigCount(params));
    }

    @Override
    public DubboResult<Boolean> delTodayRobConfig(Long configId) {
        return DubboResult.successResult(todayRobConfigService.delTodayRobConfig(configId));
    }

    @Override
    public DubboResult<Boolean> statusChange(Long configId, Integer status) {
        return DubboResult.successResult(todayRobConfigService.statusChange(configId, status));
    }

    @Override
    public DubboResult<List<TodayRobConfigDto>> findSortTodayRobConfig(Integer offset, Integer pageSize){
        return DubboResult.successResult(todayRobConfigService.findSortTodayRobConfig(offset, pageSize));
    }

    @Override
    public DubboResult<Boolean> accessSticky(Long id) {
        TodayRobConfigDto dto = todayRobConfigService.find(id);
        if(null == dto){
           return DubboResult.successResult(false);
        }
        dto.openSwitch(TodayRobConfigDto.SWITCHES_TOP);
        return DubboResult.successResult(todayRobConfigService.updateStickyTime(id, dto.getSwitches(),new Date()));
    }

    @Override
    public DubboResult<Boolean> cancelSticky(Long id) {
        TodayRobConfigDto dto = todayRobConfigService.find(id);
        if(null == dto){
           return DubboResult.successResult(false);
        }
        dto.closeSwitch(TodayRobConfigDto.SWITCHES_TOP);
        return DubboResult.successResult(todayRobConfigService.updateStickyTime(id, dto.getSwitches(),dto.getGmtCreate()));
    }

    @Override
    public DubboResult<String> cutPrice(Long todayRobConfigId,String activityType,Long consumerId, String ip, String ua,String transfer) {
        try{
            String orderNum = activityBo.cutPrice(todayRobConfigId, activityType, consumerId, ip, ua, transfer);
            return DubboResult.successResult(orderNum);
        }catch(Exception e){
            if(e instanceof StatusException){
                return DubboResult.failResult(((StatusException)e).getMessage());
            }else{
                return DubboResult.failResult(e.getMessage());
            }
        }
    }

}

