package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionBankDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionBankDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionBankEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionBankService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionBankServiceImpl implements DuibaQuestionBankService {
    @Resource
    private DuibaQuestionBankDao duibaQuestionBankDao;

    @Override
    public void insert(DuibaQuestionBankDto questionBankDO) {
        DuibaQuestionBankEntity e = BeanUtils.copy(questionBankDO, DuibaQuestionBankEntity.class);
        duibaQuestionBankDao.insert(e);
        questionBankDO.setId(e.getId());
    }

    @Override
    public List<DuibaQuestionBankDto> findByPage(Integer offset, Integer max) {
        return BeanUtils.copyList(duibaQuestionBankDao.findByPage(offset, max), DuibaQuestionBankDto.class);
    }

    @Override
    public List<DuibaQuestionBankDto> findAll() {
        return BeanUtils.copyList(duibaQuestionBankDao.findAll(), DuibaQuestionBankDto.class);
    }

    @Override
    public Long findTotalCount() {
        return duibaQuestionBankDao.findTotalCount();
    }

    @Override
    public int updateName(Long id, String name) {
        return duibaQuestionBankDao.updateName(id, name);
    }

    @Override
    public int updateNumberAdd(Long id) {
        return duibaQuestionBankDao.updateNumberAdd(id);
    }

    @Override
    public int updateNumberSub(Long id) {
        return duibaQuestionBankDao.updateNumberSub(id);
    }

    @Override
    public int delete(Long id) {
        return duibaQuestionBankDao.delete(id);
    }

    @Override
    public DuibaQuestionBankDto find(Long id) {
        return BeanUtils.copy(duibaQuestionBankDao.find(id), DuibaQuestionBankDto.class);
    }
}
