package cn.com.duiba.activity.center.biz.service.hdtool;


import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;

import java.util.List;
import java.util.Map;

public interface DuibaHdtoolOptionsService {
	public List<DuibaHdtoolOptionsDto> findByHdtoolId(Long hdtoolId);

	/**
	 * 增加奖品数量
	 */
	public int addRemainingById(Long id, Integer addRemaining);

	/**
	 * 减少奖品数量
	 */
	public int subRemainingById(Long id, Integer subRemaining);

	/**
	 * 更新库存
	 */
	public int updateRemainingById(Long id, Integer remaining);

	/**
	 * 查询奖项剩余库存，加锁
	 * @param id
	 * @return
	 */
	public Integer findRemaingForupdate(Long id);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId);

	public Map<Long, List<DuibaHdtoolOptionsDto>> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds);

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsDto findOptionById(Long id);

	public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id);

	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(Long id);

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 新增兑换活动工具奖项
	 */
	public void insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO);

}
