package cn.com.duiba.activity.center.biz.service.ngame_app.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ngame_app.NgameOrdersAppDao;
import cn.com.duiba.activity.center.biz.service.ngame_app.NgameOrdersAppService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class NgameOrdersAppServiceImpl implements NgameOrdersAppService {
    @Resource
    private NgameOrdersAppDao ngameOrdersAppDao;

    @Override
    public List<NgameOrdersDto> findByLimit(Map<String, Object> queryMap) {
        return BeanUtils.copyList(ngameOrdersAppDao.findByLimit(queryMap), NgameOrdersDto.class);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return ngameOrdersAppDao.totalCount(queryMap);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids, Long appId) {
        return BeanUtils.copyList(ngameOrdersAppDao.countFailByOperatingActivityIds(ids, appId), DeveloperActivityStatisticsDto.class);
    }
}
