package cn.com.duiba.activity.center.biz.tools.service;

import net.rubyeye.xmemcached.GetsResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;

@Service
public class AppTradingLimitService {
    
    private static Logger log = LoggerFactory.getLogger(AppTradingLimitService.class);
	
	private final String APP_NAMESPACE = "app_trading";
	@Autowired @Qualifier("memCacheClient")
    private XMemCacheClient xMemCacheClient;
	
	/**
	 * 获取今日交易数量
	 * @return
	 */
	public Integer getTodayTradingCount(Long appId){
		String key = APP_NAMESPACE+appId;
		Integer appItemCounter = 0;
		try {
			appItemCounter = (Integer) xMemCacheClient.getMemcachedClient().get(key);
			if(appItemCounter==null){
				appItemCounter = 0;
			}
		} catch (Exception e) {
		    log.error("error:",e);
		}
		return appItemCounter;
	}
	
	/**
	 * 交易次数+1
	 */
	public void addTrading(Long appId){
		try {
			String key = APP_NAMESPACE+appId;
			if(setByCas(key, 1)==2){
			    xMemCacheClient.getMemcachedClient().add(key, DateUtil.getToTomorrowSeconds(), 1);
			}
		} catch (Exception e) {
		    log.error("error:",e);
		}
	}
	
	/**
	 * 执行 cas 操作
	 * @param key
	 * @param limit
	 * @param type
	 * @return
	 */
	private Integer setByCas(final String key, final int type) {
		Integer result = null;
		boolean loop = true;
		try {
			int loopNum = 0;
			while (loop) {
				if(loopNum >= 10){
					loop = false;
					result=1;//系统繁忙
					break;
				}
				GetsResponse<Object> last = xMemCacheClient.getMemcachedClient().gets(key);
				if (last == null) {
					loop = false;
					result=2;//缓存对象为空
					break;
				} else {
					int nextValue = (Integer)last.getValue();
					if(type>0){
						nextValue = nextValue+1;
					}else if(type<0){
						nextValue = nextValue-1;
					}else{
						loop = false;
						result=4;//参数错误
						break;
					}
					boolean bo = xMemCacheClient.getMemcachedClient().cas(key,DateUtil.getToTomorrowSeconds(),nextValue,last.getCas());
					if(bo){
					    loop = false;
                        result=0; //更新成功
                        break;
					}
				}
				loopNum++;
			}
		} catch (Exception e) {
		    log.error("error:",e);
			result=5;
		}
		return result;
	}

}
