/**
 * Project Name:activity-center-biz
 * File Name:ItemKeyStockServcie.java
 * Package Name:cn.com.duiba.activity.center.biz.tools
 * Date:2016年7月29日下午1:43:27
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.tools.service;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;

/**
 * ClassName:ItemKeyStockServcie <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午1:43:27 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ItemKeyStockServcie {
    
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemotePreStockService remotePreStockService;

    public Integer findRemaining(ItemKey itemKey){
        Integer remaining = 0;
        //Item模式
        if (itemKey.isItemMode()|| itemKey.isDuibaAppItemMode()) {
            ItemDO item = itemKey.getItem();
            //直冲类型
            if(item.isNoStock()){
                return 100000000;
            }
            //优惠券
            CouponBatchDO batch = remoteCouponService.getCurrentBatch(itemKey);
            if (batch != null) {
                remaining = Math.min(item.getRemaining(), batch.getRemaining()) ;
            }else{
                remaining = item.getRemaining();
            }
            //如果是定向兑换项就去定向库存  总库存小于等于0 就没必要取定向库存
            if (remaining!=null&&remaining>0&&item.isOpTypeItem(ItemDO.OpTypeSpecify)) {
                Integer specifyRemaining = remoteItemAppSpecifyService.findSpecifyRemaining(item.getId(), itemKey.getApp().getId());
                if (specifyRemaining != null && specifyRemaining <= remaining) {
                    remaining = specifyRemaining;
                }
            }
            //如果是库存预分配
            if(remaining!=null&&remaining>0&&item.isOpTypeItem(ItemDO.OpTypePreStockSwith)){
                Long stock = remotePreStockService.getPreStock(itemKey.getItem(), itemKey.getApp());
                if(null != stock && stock <= remaining){
                    remaining = stock.intValue();
                }
            }
        //AppItem模式
        }else if (itemKey.isSelfAppItemMode()) {
            //优惠券
            CouponBatchDO batch = remoteCouponService.getCurrentBatch(itemKey);
            if (batch != null) {
                remaining = Math.min(itemKey.getAppItem().getRemaining(), batch.getRemaining()) ;
            }else{
                remaining = itemKey.getAppItem().getRemaining();
            }
        }
        return remaining;
    }
    
    public boolean couponBatchCheck(ItemKey itemKey){
        // 优惠券批次校验
        if (ItemDO.TypeCoupon.equals(itemKey.getItemType())) {
            if ((itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) && itemKey.getItem().getBatchId() == null) {
                return false;
            } else if (itemKey.isSelfAppItemMode() && itemKey.getAppItem().getBatchId() == null) {
                return false;
            }
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    return false;
                }
            } else if (itemKey.isSelfAppItemMode()) {
                if (itemKey.getAppItem().getValidEndDate() != null && new Date().after(itemKey.getAppItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                    return false;
                }
            }
        }
        return true;
    }
}

