/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.activity;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryActivityBo {
    private static final Logger log = LoggerFactory.getLogger(CategoryActivityBo.class);
    @Autowired
    private ActivityCategoryService activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;
    @Autowired
    private OperatingActivityService operatingActivityService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Autowired
    private DuibaHdtoolService duibaHdtoolService;
    @Autowired
    private DuibaQuizzService duibaQuizzService;
    @Autowired
    private DuibaQuestionAnswerService duibaQuestionAnswerService;
    @Autowired
    private DuibaGuessService duibaGuessService;
    @Autowired
    private DuibaNgameService duibaNgameService;
    @Autowired
    private SingleLotteryService singleLotteryService;
    @Autowired
    private AppManualLotteryService appManualLotteryService;

    public List<CategoryActivityDto> findAllActivitiesByAppCategory(long appId, long categoryId, long consumerId, String ip, String os, String clickUlr, int start, int pageSize) {
        List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId, categoryId, start, pageSize);
        ArrayList<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
        ArrayList<CategoryActivityDto> rs = new ArrayList<CategoryActivityDto>();
        HashSet<Long> operatingActivityIdSet = new HashSet<Long>();
        if (acrs != null && acrs.size() > 0) {
            for (ActivityCategoryRelationEntity acr : acrs) {
                CategoryActivityDto dto = new CategoryActivityDto();
                dto.setId(acr.getId());
                dto.setOperatingId(acr.getOperatingActivityId());
                dto.setPayload(acr.getPayload());
                dto.setAppId(Long.valueOf(appId));
                dto.setCategoryId(Long.valueOf(categoryId));
                dtos.add(dto);
                operatingActivityIdSet.add(acr.getOperatingActivityId());
            }
            List<OperatingActivityDto> activityDtos = this.operatingActivityService.findAllByIds(new ArrayList<Long>(operatingActivityIdSet));
            HashMap<Long, OperatingActivityDto> map = new HashMap<Long, OperatingActivityDto>();
            for (OperatingActivityDto activityDto : activityDtos) {
                map.put(activityDto.getId(), activityDto);
            }
            for (CategoryActivityDto cat : dtos) {
                OperatingActivityDto activity = (OperatingActivityDto)map.get(cat.getOperatingId());
                cat.setType(activity.getType());
                cat.setActivityId(activity.getActivityId());
                cat.setTitle(activity.getTitle());
                cat.setBanner(activity.getBannerImage());
                cat.setThumb(activity.getSmallImage());
                cat.setLogo(activity.getLogo());
                if (activity == null || activity.getStatus() != 2) continue;
                JSONObject json = new JSONObject();
                String infoType = this.setImage(cat);
                json.put("app_id", (Object)appId);
                json.put("consumer_id", (Object)consumerId);
                json.put("login_type", (Object)1);
                json.put("info_type", (Object)infoType);
                json.put("info", (Object)activity.getActivityId());
                json.put("ip", (Object)ip);
                json.put("os", (Object)os);
                json.put("domain", (Object)clickUlr);
                if (infoType.equals("9")) {
                    json.put("activity_type", (Object)9);
                    json.put("duiba_activity_id", (Object)activity.getActivityId());
                }
                ItemKey key = this.remoteItemKeyService.getItemKeyIncludeDeleted(null, activity.getAppItemId(), Long.valueOf(appId));
                ItemKeyVO itemKeyVo = new ItemKeyVO(key);
                if (activity.getCustomCredits() != null && activity.getCustomCredits() > 0L) {
                    cat.setCredits(activity.getCustomCredits());
                } else {
                    cat.setCredits(activity.getCredits());
                }
                cat.setLink(itemKeyVo.getLink());
                cat.setSt_info(json.toJSONString());
                rs.add(cat);
            }
        }
        return rs;
    }

    public String setImage(CategoryActivityDto activity) {
        Integer type = activity.getType();
        Long activityId = activity.getActivityId();
        String infotype = "1";
        if (type == 1) {
            infotype = "6";
        } else if (this.isAppHdtool(activity)) {
            infotype = "3";
        } else if (type == 2) {
            DuibaSingleLotteryDto entity = this.duibaSingleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            infotype = "5";
        } else if (activity.isHdTool() && activityId != null) {
            DuibaHdtoolDto entity = this.duibaHdtoolService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = "7";
        } else if (type == 41) {
            DuibaQuizzDto entity = this.duibaQuizzService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = "13";
        } else if (type == 40) {
            DuibaQuestionAnswerDto entity = this.duibaQuestionAnswerService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = "12";
        } else if (type == 42) {
            DuibaGuessDto entity = this.duibaGuessService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = "14";
        } else if (type == 28) {
            DuibaNgameDto entity = this.duibaNgameService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = "9";
        } else if (type == 3) {
            AppSingleLotteryDto entity = this.singleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            infotype = "3";
        } else if (type == 5) {
            AppManualLotteryDto entity = this.appManualLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            infotype = "3";
        }
        return infotype;
    }

    public boolean isAppHdtool(CategoryActivityDto oa) {
        boolean rs = false;
        if (oa.isHdTool() && oa.getActivityId() == null) {
            rs = true;
        }
        return rs;
    }
}

