/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDataSource {
    private static final Logger log = LoggerFactory.getLogger(ReadDataSource.class);
    protected static List<ReadDataSource> readonlyDatasource = new ArrayList<ReadDataSource>();
    public static final String MASTER = "dataSource";
    public static final String READ_1 = "readOnly1";
    public static final String READ_2 = "readOnly2";
    private String dataSource = "dataSource";
    private boolean down = false;
    private static AtomicLong index;

    public static String getReadOnlyDateSource() {
        try {
            ArrayList<ReadDataSource> activeReadSource = new ArrayList<ReadDataSource>();
            for (ReadDataSource source : readonlyDatasource) {
                if (source.isDown()) continue;
                activeReadSource.add(source);
            }
            ReadDataSource dataSource = ReadDataSource.getServer(activeReadSource);
            if (dataSource == null) {
                return MASTER;
            }
            return dataSource.getDataSource();
        }
        catch (Exception e) {
            log.error("getReadOnlyDateSource :", (Throwable)e);
            return MASTER;
        }
    }

    public static ReadDataSource getServer(List<ReadDataSource> activeDataSource) {
        if (activeDataSource == null || activeDataSource.size() < 1) {
            return null;
        }
        long value = index.getAndIncrement();
        int i = (int)(value % (long)activeDataSource.size());
        return activeDataSource.get(i);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    static {
        ReadDataSource readOnly1 = new ReadDataSource();
        readOnly1.setDataSource(READ_1);
        readonlyDatasource.add(readOnly1);
        ReadDataSource readOnly2 = new ReadDataSource();
        readOnly2.setDataSource(READ_2);
        readonlyDatasource.add(readOnly2);
        index = new AtomicLong(0L);
    }
}

