/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.CreditsHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class CreditsHdtoolOrdersDaoImpl
extends ActivityBaseDao
implements CreditsHdtoolOrdersDao {
    @Override
    public HdtoolOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return (HdtoolOrdersEntity)this.selectOne("find", paramMap);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    @Override
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("prizeId", prizeId);
        return (Integer)this.selectOne("countByConsumerIdAndPrizeId", paramMap);
    }

    @Override
    public List<HdtoolOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("ids", ids);
        return this.selectList("findByIds", paramMap);
    }

    @Override
    public HdtoolOrdersEntity findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("appId", appId);
        paramMap.put("bizId", bizId);
        return (HdtoolOrdersEntity)this.selectOne("findByAppAndDeveloperBizId", paramMap);
    }

    @Override
    public List<Long> findExpireOrder() {
        HashMap<String, Comparable<Date>> paramMap = new HashMap<String, Comparable<Date>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        Date endTime = cal.getTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(endTime);
        cal1.add(5, -1);
        Date startTime = cal1.getTime();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put("exchangeStatus", Integer.valueOf(1));
        return this.selectList("findExpireOrder", paramMap);
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", 3);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", 4);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToOverdue", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("status", 2);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateStatusToFail", paramMap);
        return ret;
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("doTakePrize", paramMap);
        return ret;
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("rollbackTakePrize", paramMap);
        return ret;
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        paramMap.put("status", 1);
        paramMap.put("exchangeStatus", 1);
        int ret = this.update("updateLotteryResult", paramMap);
        return ret;
    }

    @Override
    public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        paramMap.put("status", 1);
        paramMap.put("exchangeStatus", 1);
        int ret = this.update("updateLotteryLuckyResult", paramMap);
        return ret;
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("bizId", bizId);
        int ret = this.update("updateDeveloperBizId", paramMap);
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("mainOrderId", mainOrderId);
        paramMap.put("mainOrderNum", mainOrderNum);
        int ret = this.update("updateMainOrderId", paramMap);
        return ret;
    }

    @Override
    public void insert(HdtoolOrdersEntity hdtoolOrdersDto) {
        this.generateHdtoolOrderSequence(hdtoolOrdersDto);
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(hdtoolOrdersDto.getConsumerId());
        paramMap.put("mirror", hdtoolOrdersDto);
        this.insert("insert", paramMap);
    }

    private void generateHdtoolOrderSequence(HdtoolOrdersEntity hdtoolOrdersDto) {
        this.insert("generateHdtoolOrderSequence", hdtoolOrdersDto);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_HDTOOL;
    }
}

