/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityItemPreStockPluginImpl
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityItemPreStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemotePreStockService remotePreStockService;
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        private static final String ACTIVITY_PRE_STOCK = "__activity_pre_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    PreStockPointDO point;
                    ItemKey key = ActivityItemPreStockPluginImpl.this.remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    if (key.getItem() != null && key.getItem().isOpTypeItem(10) && null != (point = ActivityItemPreStockPluginImpl.this.remotePreStockService.getPointStock(key.getItem(), key.getApp()))) {
                        ActivityItemPreStockPluginImpl.this.remotePreStockService.consumeStock("activity-" + order.getOrderNum(), key.getApp().getId(), point.getId());
                        context.setAttribute(ACTIVITY_PRE_STOCK, true);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u51cf\u9884\u5206\u914d\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    ItemKey key = ActivityItemPreStockPluginImpl.this.remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    if (key.getItem() != null && key.getItem().isOpTypeItem(10)) {
                        Boolean hasadd = (Boolean)context.getAttribute(ACTIVITY_PRE_STOCK);
                        if (hasadd != null && hasadd.booleanValue()) {
                            ActivityItemPreStockPluginImpl.this.remotePreStockService.paybackStock("activity-" + order.getOrderNum());
                        }
                        context.remove(ACTIVITY_PRE_STOCK);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u8fd4\u9884\u5206\u914d\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(this.orderPlugin);
    }
}

