/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.redis.RedisClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerActivityLimitServiceImpl
implements ConsumerActivityLimitService {
    @Autowired
    private RedisClient redisClient;
    private long todayTTL = 86400L;
    private long foreverTTL = 7776000L;

    @Override
    public Integer findConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
        String value = this.redisClient.get(RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId));
        if (StringUtils.isNotBlank((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerJoinNumToday(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId);
        if (joinNum == null) {
            String ret = this.redisClient.set(key, "1", "nx", "ex", this.todayTTL);
            if (ret == null) {
                return false;
            }
        } else {
            this.redisClient.incr(key);
        }
        return true;
    }

    @Override
    public boolean decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerJoinNumToday(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId);
        if (joinNum != null) {
            this.redisClient.decr(key);
        }
        return true;
    }

    @Override
    public Integer findConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
        String value = this.redisClient.get(RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId));
        if (StringUtils.isNotBlank((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerJoinNumForever(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId);
        if (joinNum == null) {
            String ret = this.redisClient.set(key, "1", "nx", "ex", this.foreverTTL);
            if (ret == null) {
                return false;
            }
        } else {
            this.redisClient.incr(key);
        }
        return true;
    }

    @Override
    public boolean decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerJoinNumForever(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId);
        if (joinNum != null) {
            this.redisClient.decr(key);
        }
        return true;
    }

    @Override
    public Integer findConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
        String value = this.redisClient.get(RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId));
        if (StringUtils.isNotBlank((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerFreeNumToday(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId);
        if (joinNum == null) {
            String ret = this.redisClient.set(key, "1", "nx", "ex", this.todayTTL);
            if (ret == null) {
                return false;
            }
        } else {
            this.redisClient.incr(key);
        }
        return true;
    }

    @Override
    public boolean decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerFreeNumToday(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId);
        if (joinNum != null) {
            this.redisClient.decr(key);
        }
        return true;
    }

    @Override
    public Integer findConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
        String value = this.redisClient.get(RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId));
        if (StringUtils.isNotBlank((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerFreeNumForever(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId);
        if (joinNum == null) {
            String ret = this.redisClient.set(key, "1", "nx", "ex", this.foreverTTL);
            if (ret == null) {
                return false;
            }
        } else {
            this.redisClient.incr(key);
        }
        return true;
    }

    @Override
    public boolean decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
        Integer joinNum = this.findConsumerFreeNumForever(consumerId, operatingActivityId);
        String key = RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId);
        if (joinNum != null) {
            this.redisClient.decr(key);
        }
        return true;
    }

    @Override
    public Integer findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
        String value = this.redisClient.get(RedisKeyFactory.getConsumerWinOptionNumKey(consumerId, operatingActivityId, optionId));
        if (StringUtils.isNotBlank((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    @Override
    public boolean incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
        Integer joinNum = this.findConsumerWinOptionNum(consumerId, operatingActivityId, optionId);
        String key = RedisKeyFactory.getConsumerWinOptionNumKey(consumerId, operatingActivityId, optionId);
        if (joinNum == null) {
            String ret = this.redisClient.set(key, "1", "nx", "ex", this.foreverTTL);
            if (ret == null) {
                return false;
            }
        } else {
            this.redisClient.incr(key);
        }
        return true;
    }
}

