/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.direct.impl;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.biz.dao.direct.DeveloperActivityBlackDao;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeveloperActBlackServiceImpl
implements DeveloperActBlackService {
    private static Logger log = LoggerFactory.getLogger(DeveloperActBlackServiceImpl.class);
    @Resource
    private DeveloperActivityBlackDao developerActivityBlackDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public List<ActivityBlackList4DeveloperDto> createBlackList(List<ActivityBlackList4DeveloperDto> blacks) {
        if (blacks == null) {
            return null;
        }
        ArrayList<ActivityBlackList4DeveloperDto> rs = new ArrayList<ActivityBlackList4DeveloperDto>();
        for (ActivityBlackList4DeveloperDto black : blacks) {
            int num = this.developerActivityBlackDao.query(black);
            if (num != 0) continue;
            this.developerActivityBlackDao.insert(black);
            this.removeBlackCache(black);
            rs.add(black);
        }
        return rs;
    }

    @Override
    public ActivityBlackList4DeveloperDto insertActivityBalack(ActivityBlackList4DeveloperDto black) {
        if (black == null) {
            return null;
        }
        int num = this.developerActivityBlackDao.query(black);
        if (num == 0) {
            this.developerActivityBlackDao.insert(black);
            this.removeBlackCache(black);
            return black;
        }
        return null;
    }

    @Override
    public Boolean removeBlack(Long id) {
        try {
            ActivityBlackList4DeveloperDto black = this.developerActivityBlackDao.find(id);
            if (black != null) {
                this.developerActivityBlackDao.remove(id);
                this.removeBlackCache(black);
                return true;
            }
            log.error("\u5220\u9664\u9ed1\u540d\u5355\u5931\u8d25,\u8be5id\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9ed1\u540d\u5355\u5931\u8d25," + e);
        }
        return false;
    }

    @Override
    public List<ActivityBlackList4DeveloperDto> queryByActivity(Long activityId, Integer activityType, Integer offset, Integer max) {
        if (activityId == null || activityType == null) {
            return null;
        }
        if (offset == null || offset < 0) {
            offset = 0;
        }
        if (max == null || max <= 0) {
            max = 10;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("activityType", activityType);
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        return this.developerActivityBlackDao.queryByActivity(paramMap);
    }

    @Override
    public Integer queryCountByActivity(Long activityId, Integer activityType) {
        return this.developerActivityBlackDao.queryCountByActivity(activityId, activityType);
    }

    @Override
    public Integer query(ActivityBlackList4DeveloperDto black) {
        return this.developerActivityBlackDao.query(black);
    }

    @Override
    public void removeBlackCache(ActivityBlackList4DeveloperDto black) {
        log.debug("\u9ed1\u540d\u5355\u5220\u9664\u7f13\u5b58,key=" + this.getBlackCacheKey(black));
        this.memcachedClient.remove(this.getBlackCacheKey(black));
    }

    @Override
    public void setBlackCache(ActivityBlackList4DeveloperDto black, Boolean value) {
        log.debug("\u9ed1\u540d\u5355\u67e5\u8be2\u8bbe\u7f6e\u7f13\u5b58,key=" + this.getBlackCacheKey(black) + ",value=" + value);
        this.memcachedClient.set(this.getBlackCacheKey(black), (Object)value, 300);
    }

    public String getBlackCacheKey(ActivityBlackList4DeveloperDto black) {
        return "chaos.black_" + black.getDeveloperId() + "_" + black.getActivityId() + "_" + black.getActivityType();
    }
}

