/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerBrickDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerBrickDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerBrickEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerBrickService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerBrickServiceImpl
implements DuibaQuestionAnswerBrickService {
    @Resource
    private DuibaQuestionAnswerBrickDao duibaQuestionAnswerBrickDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public DuibaQuestionAnswerBrickDto find(Long id) {
        return (DuibaQuestionAnswerBrickDto)BeanUtils.copy((Object)this.duibaQuestionAnswerBrickDao.find(id), DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public void insert(DuibaQuestionAnswerBrickDto duibaQuestionAnswerBrick) {
        DuibaQuestionAnswerBrickEntity e = (DuibaQuestionAnswerBrickEntity)BeanUtils.copy((Object)duibaQuestionAnswerBrick, DuibaQuestionAnswerBrickEntity.class);
        this.duibaQuestionAnswerBrickDao.insert(e);
        duibaQuestionAnswerBrick.setId(e.getId());
    }

    @Override
    public void update4Admin(Long id, String title, String content, String md5) {
        this.duibaQuestionAnswerBrickDao.update4Admin(id, title, content, md5);
        this.cacheClient.remove(this.getNoContentCacheKey(id));
        this.cacheClient.remove(this.getContentCacheKey(id));
    }

    @Override
    public DuibaQuestionAnswerBrickDto findByTitle(String title) {
        return (DuibaQuestionAnswerBrickDto)BeanUtils.copy((Object)this.duibaQuestionAnswerBrickDao.findByTitle(title), DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public void open(Long id) {
        this.duibaQuestionAnswerBrickDao.open(id);
        this.cacheClient.remove(this.getNoContentCacheKey(id));
    }

    @Override
    public void disable(Long id) {
        this.duibaQuestionAnswerBrickDao.disable(id);
        this.cacheClient.remove(this.getNoContentCacheKey(id));
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(this.duibaQuestionAnswerBrickDao.findPage(queryMap), DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return this.duibaQuestionAnswerBrickDao.findPageCount();
    }

    @Override
    public List<DuibaQuestionAnswerBrickDto> findAll() {
        return BeanUtils.copyList(this.duibaQuestionAnswerBrickDao.findAll(), DuibaQuestionAnswerBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {
        return (String)this.cacheClient.getWithCacheLoader(this.getContentCacheKey(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return DuibaQuestionAnswerBrickServiceImpl.this.duibaQuestionAnswerBrickDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKey(Long id) {
        return "activity-duibaQuestionAnswerBrickNoContentById_" + id;
    }

    private String getContentCacheKey(Long id) {
        return "activity-duibaQuestionAnswerBrickContentById_" + id;
    }

    @Override
    public DuibaQuestionAnswerBrickDto findNoContent(Long id) {
        String key = this.getNoContentCacheKey(id);
        DuibaQuestionAnswerBrickDto dto = (DuibaQuestionAnswerBrickDto)this.cacheClient.get(key);
        if (dto == null) {
            dto = (DuibaQuestionAnswerBrickDto)BeanUtils.copy((Object)this.duibaQuestionAnswerBrickDao.findNoContent(id), DuibaQuestionAnswerBrickDto.class);
            this.cacheClient.set(key, (Object)dto, 30, TimeUnit.MINUTES);
        }
        return dto;
    }
}

