/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;
import cn.com.duiba.activity.center.biz.dao.game.GameOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.entity.game.GameOrdersEntity;
import cn.com.duiba.activity.center.biz.service.game.GameOrdersSimpleService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameOrdersSimpleServiceImpl
implements GameOrdersSimpleService {
    @Autowired
    private GameOrdersSimpleDao gameOrdersSimpleDao;

    @Override
    public GameOrdersDto find(Long gameOrderId) {
        return (GameOrdersDto)BeanUtils.copy((Object)((Object)this.gameOrdersSimpleDao.find(gameOrderId)), GameOrdersDto.class);
    }

    @Override
    public List<GameOrdersDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(this.gameOrdersSimpleDao.findByIds(ids), GameOrdersDto.class);
    }

    @Override
    public void insert(GameOrdersDto gameOrdersDto) {
        GameOrdersEntity gameOrdersEntity = (GameOrdersEntity)((Object)BeanUtils.copy((Object)gameOrdersDto, GameOrdersEntity.class));
        this.gameOrdersSimpleDao.insert(gameOrdersEntity);
        gameOrdersDto.setId(gameOrdersEntity.getId());
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return this.gameOrdersSimpleDao.findConsumerFreeNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.gameOrdersSimpleDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return this.gameOrdersSimpleDao.findConsumerLimitNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.gameOrdersSimpleDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public GameOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return (GameOrdersDto)BeanUtils.copy((Object)((Object)this.gameOrdersSimpleDao.findByAppAndDeveloperBizId(appId, bizId)), GameOrdersDto.class);
    }

    @Override
    public Integer countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return this.gameOrdersSimpleDao.countConsumerByPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<Long> findOverdueOrder() {
        return this.gameOrdersSimpleDao.findOverdueOrder();
    }

    @Override
    public Integer countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
        return this.gameOrdersSimpleDao.countConsumerByGameConfigDuibaId(consumerId, gameConfigDuibaId);
    }

    @Override
    public Long countRow(Map<String, Object> paramMap) {
        return this.gameOrdersSimpleDao.countRow(paramMap);
    }

    @Override
    public List<GameOrdersSimpleDto> findByLimit(Map<String, Object> paramMap) {
        return BeanUtils.copyList(this.gameOrdersSimpleDao.findByLimit(paramMap), GameOrdersSimpleDto.class);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        return BeanUtils.copyList(this.gameOrdersSimpleDao.countFailByOperatingActivityIds(ids), DeveloperActivityStatisticsDto.class);
    }
}

