/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;
import net.rubyeye.xmemcached.GetsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TodayCountService {
    private static Logger log = LoggerFactory.getLogger(TodayCountService.class);
    @Autowired
    @Qualifier(value="memCacheClient")
    private XMemCacheClient xMemCacheClient;
    private final String EXPECT_NAMESPACE = "expectnamespace";

    public void addExpectByCredits(Long appId, Long credits) {
        try {
            String creditsKey;
            if (credits > 0L && this.setByCas(creditsKey = "expectnamespace" + appId + "credits", credits.intValue(), 1) == 2) {
                this.xMemCacheClient.getMemcachedClient().set(creditsKey, DateUtil.getToTomorrowSeconds(), (Object)credits.intValue());
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u79ef\u5206\u5f02\u5e38", (Throwable)e);
        }
    }

    private Integer setByCas(String key, int value, int type) {
        Integer result = null;
        try {
            int loopNum = 0;
            while (true) {
                if (loopNum >= 10) {
                    result = 1;
                    break;
                }
                GetsResponse last = this.xMemCacheClient.getMemcachedClient().gets(key);
                if (last == null) {
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    nextValue += value;
                } else if (type < 0) {
                    nextValue = nextValue >= value ? (nextValue -= value) : 0;
                } else {
                    result = 4;
                    break;
                }
                boolean bo = this.xMemCacheClient.getMemcachedClient().cas(key, DateUtil.getToTomorrowSeconds(), (Object)nextValue, last.getCas());
                if (bo) {
                    result = 0;
                    break;
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
            log.error("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    public class ExpectVO {
        private Integer orderCount = 0;
        private Integer credits = 0;
        private Integer actualPrice = 0;

        public Integer getOrderCount() {
            return this.orderCount;
        }

        public void setOrderCount(Integer orderCount) {
            this.orderCount = orderCount;
        }

        public Integer getCredits() {
            return this.credits;
        }

        public void setCredits(Integer credits) {
            this.credits = credits;
        }

        public Integer getActualPrice() {
            return this.actualPrice;
        }

        public void setActualPrice(Integer actualPrice) {
            this.actualPrice = actualPrice;
        }
    }
}

