package cn.com.duiba.activity.center.biz.dao;

/**
 * Created by wenqi.huang on 16/4/8. 这个枚举类用于表示当前的dao应该选择哪个sqlSessionTemplate.
 */
public enum DatabaseSchema {
    /**
     * 手机端credits_dev主库
     */
    CREDITS(DsConstants.DATABASE_CREDITS),
    /**
     * credits_game库
     */
    CREDITS_GAME(DsConstants.DATABASE_CREDITS_GAME),
    /**
     * quizz库
     */
    QUIZZ(DsConstants.DATABASE_QUIZZ),

    /**
     * quizz库--消费者纬度
     */
    QUIZZ_CONSUMER(DsConstants.DATABASE_QUIZZ_CONSUMER),

    /**
     * quizz库--消费者纬度
     */
    QUIZZ_APP(DsConstants.DATABASE_QUIZZ_APP),

    /**
     * seckill库
     */
    SECKILL(DsConstants.DATABASE_SECKILL),
    /**
     * seckill_APP库
     */
    SECKILL_APP(DsConstants.DATABASE_SECKILL_APP),
    /**
     * creditsActivity库
     */
    CREDITS_ACTIVITY(DsConstants.DATABASE_CREDITS_ACTIVITY),
    /**
     * manager 库
     */
    MANAGER(DsConstants.DATABASE_MANAGER),
    /**
     * ngame 库
     */
    NGAME(DsConstants.DATABASE_NGAME),
    /**
     * ngame_app 库,ngame_orders表按app维度分表
     */
    NGAME_APP(DsConstants.DATABASE_NGAME_APP),
    /**
     * ngame_con 库,ngame_orders表按consumer维度分表
     */
    NGAME_CON(DsConstants.DATABASE_NGAME_CON),
    /**
     * consumer库,拥有consumer的1024张分表
     */
    CONSUMER(DsConstants.DATABASE_CONSUMER),
    /**
     * mng_hdtool 库
     */
    MNG_HDTOOL(DsConstants.DATABASE_MNG_HDTOOL),
    /**
     * app_hdtool 库
     */
    APP_HDTOOL(DsConstants.DATABASE_APP_HDTOOL),
    /**
     * credits_hdtool 库
     */
    CREDITS_HDTOOL(DsConstants.DATABASE_CREDITS_HDTOOL),
    /**
     * guess 库
     */
    GUESS(DsConstants.DATABASE_GUESS),
    /**
     * guess_app 库guess_orders表按app维度分表
     */
    GUESS_APP(DsConstants.DATABASE_GUESS_APP),
    /**
     * guess_con 库guess_orders表按consumer维度分表
     */
    GUESS_CON(DsConstants.DATABASE_GUESS_CON);

    private String name;

    private DatabaseSchema(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static DatabaseSchema nameOf(String name) {
        for (DatabaseSchema d : DatabaseSchema.values()) {
            if (d.getName().equals(name)) {
                return d;
            }
        }
        return null;
    }

}
