package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzAppOrderDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;

@Repository
public class QuizzAppOrderDaoImpl extends ActivityBaseDao implements QuizzAppOrderDao {

    @Override
    public List<QuizzOrdersEntity> findQuizzOrderLimit50(Long appId, Long activityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(appId);
        paramMap.put("appId", appId);
        paramMap.put("activityId", activityId);
        return selectList("findQuizzOrderLimit50", paramMap);
    }
    
    @Override
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(
			List<Long> ids, Long appId) {
    	Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(appId);
    	paramMap.put("ids", ids);
    	paramMap.put("appId", appId);
    	return selectList("countFailByOperatingActivityIds", paramMap);
	}
    
    @Override
	public List<QuizzOrdersEntity> findByLimit(Map<String, Object> map) {
        Long appId= (Long)map.get("appId");
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(appId);
        paramMap.putAll(map);
		return selectList("findByLimit", paramMap);
	}

	@Override
	public Long totalCount(Map<String, Object> map) {
        Long appId= (Long)map.get("appId");
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(appId);
        paramMap.putAll(map);
		return selectOne("totalCount", paramMap);
	}
	
	@Override
	public Integer insert(QuizzOrdersEntity quizzOrdersEntity, long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(quizzOrdersEntity.getAppId());
        quizzOrdersEntity.setId(id);
        paramMap.put("mirror", quizzOrdersEntity);
        return insert("insert", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ_APP;
    }

}
