package cn.com.duiba.activity.center.biz.plugin.event;

import java.util.ArrayList;
import java.util.List;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent.ConsumeCreditsFailListener;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent.ConsumeCreditsSuccessListener;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventListener;

public class DuibaEventsRegister {

	private static DuibaEventsRegister instance=new DuibaEventsRegister();
	
	private DuibaEventsRegister(){
	}
	public static DuibaEventsRegister get(){
		return instance;
	}
	List<ActivityOrdersEventListener> activityOrderListener = new ArrayList<ActivityOrdersEventListener>();
	List<ActivityOrderSyncEvent> activityOrderPlugins=new ArrayList<ActivityOrderSyncEvent>();
    List<ConsumeCreditsFailListener>  consumeCreditsFailListeners = new ArrayList<ConsumeCreditsFailListener>();
    List<ConsumeCreditsSuccessListener>  consumeCreditsSuccessListeners = new ArrayList<ConsumeCreditsSuccessListener>();
    
    
    public void registConsumeCreditsFailEvent(ConsumeCreditsFailListener listener){
        if(!consumeCreditsFailListeners.contains(listener)){
            consumeCreditsFailListeners.add(listener);
        }
    }
    
    public void unregistConsumeCreditsFailEvent(ConsumeCreditsFailListener listener){
        consumeCreditsFailListeners.remove(listener);
    }
    
    public void registConsumeCreditsSuccessEvent(ConsumeCreditsSuccessListener listener){
        if(!consumeCreditsSuccessListeners.contains(listener)){
            consumeCreditsSuccessListeners.add(listener);
        }
    }
    
    public void unregistConsumeCreditsSuccessEvent(ConsumeCreditsSuccessListener listener){
        consumeCreditsSuccessListeners.remove(listener);
    }
    
	public void addActivityOrdersPlugin(ActivityOrderSyncEvent plugin){
	    activityOrderPlugins.add(plugin);
    }
    
    public void removeActivityOrdersPlugin(ActivityOrderSyncEvent plugin){
        activityOrderPlugins.remove(plugin);
    }
	
	public void registActivityOrdersEvent(ActivityOrdersEventListener listener){
		if(!activityOrderListener.contains(listener)){
		    activityOrderListener.add(listener);
		}
	}

	public void unregistActivityOrdersEvent(ActivityOrdersEventListener listener){
	    activityOrderListener.remove(listener);
	}
}
