package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessStockDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteDuibaGuessStockService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessStockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class RemoteDuibaGuessStockServiceImpl implements RemoteDuibaGuessStockService {

    @Autowired
    private DuibaGuessStockService duibaGuessStockService;

    @Override
    public DuibaGuessStockDto findRemaining(Long relationId) {
        return duibaGuessStockService.findRemaining(relationId);
    }

    @Override
    public int subStock(Long id, Integer subNumber) {
        return duibaGuessStockService.subStock(id,subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return duibaGuessStockService.addStock(id,addNumber);
    }

    @Override
    public DuibaGuessStockDto findByGuessOptionId(Long guessOptionId) {
        return duibaGuessStockService.findByGuessOptionId(guessOptionId);
    }

    @Override
    public List<DuibaGuessStockDto> findByGuessOptionIds(List<Long> list) {
        return duibaGuessStockService.findByGuessOptionIds(list);
    }

    /**
     * 增加库存
     *
     * @param id
     * @param stockAdd
     * @return
     */
    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        return duibaGuessStockService.updateStockAdd(id,stockAdd);
    }

    /**
     * 减少库存
     *
     * @param id
     * @param stockSub
     * @return
     */
    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        return duibaGuessStockService.updateStockSub(id,stockSub);
    }

    @Override
    public DuibaGuessStockDto add(DuibaGuessStockDto guessStockDO) {
        duibaGuessStockService.add(guessStockDO);
        return guessStockDO;
    }

    @Override
    public void addBatch(List<DuibaGuessStockDto> list) {
        duibaGuessStockService.addBatch(list);
    }
}
