package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersExtraDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteGuessOrdersExtraService;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersExtraService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class RemoteGuessOrdersExtraServiceImpl implements RemoteGuessOrdersExtraService {

    @Autowired
    private GuessOrdersExtraService guessOrdersExtraService;

    @Override
    public GuessOrdersExtraDto find(Long id) {
        return guessOrdersExtraService.find(id);
    }

    @Override
    public GuessOrdersExtraDto insert(GuessOrdersExtraDto guessOrdersExtraDto) {
        guessOrdersExtraService.insert(guessOrdersExtraDto);
        return guessOrdersExtraDto;
    }

    @Override
    public int updateOrderId(Long id, Long mainOrderId, String mainOrderNum) {
        return guessOrdersExtraService.updateOrderId(id,mainOrderId,mainOrderNum);
    }

    @Override
    public List<Long> findWiningPrizeIds(Long consumerId, Long duibaGuessId) {
        return guessOrdersExtraService.findWiningPrizeIds(consumerId,duibaGuessId);
    }

    @Override
    public void updateNotPrize(Long guessExtraOrderId) {
        guessOrdersExtraService.updateNotPrize(guessExtraOrderId);
    }
}
