package cn.com.duiba.activity.center.biz.service.game.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity.QuestionRecordDto;
import cn.com.duiba.activity.center.biz.dao.game.DevelopQuestionRecordDao;
import cn.com.duiba.activity.center.biz.entity.game.QuestionRecordEntity;
import cn.com.duiba.activity.center.biz.service.game.DevelopQuestionRecordService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by gey on 16/8/26.
 */
@Service
public class DevelopQuestionRecordServiceImpl implements DevelopQuestionRecordService {
	
	@Resource
	private DevelopQuestionRecordDao developQuestionRecordDao;

	@Override
	public List<QuestionRecordDto> findByQuestionRecordId(Long activityId) {
		List<QuestionRecordDto> list =new ArrayList<QuestionRecordDto>();
		List<QuestionRecordEntity> listEnt = developQuestionRecordDao.findByQuestionRecordId(activityId);
		for(QuestionRecordEntity en:listEnt){
			list.add(BeanUtils.copy(en,QuestionRecordDto.class));
		}
		return list;
	}

	@Override
	public void saveOrUpdateQuestionRecord(Long activityId, String[] questionRecord,int optionNum) {
		
		//获取答题id
		List<Long> awardIds = new ArrayList<Long>();
		for(int i=0;i<questionRecord.length;i++){
			JSONObject jsonOption = JSONObject.parseObject(questionRecord[i]);
			Long id = jsonOption.getLong("id");
			if(null != id){
				awardIds.add(id);
			}
		}
		//判断题目是否有删除项
		List<QuestionRecordEntity> oaoList = developQuestionRecordDao.findByQuestionRecordId(activityId);
		if(!oaoList.isEmpty() && !awardIds.isEmpty()){
			if(awardIds.size() != oaoList.size()){
				List<Long> oaoIds = new ArrayList<Long>();
				for(QuestionRecordEntity oao : oaoList){
					oaoIds.add(oao.getId());
				}
				for(int i=0;i<awardIds.size();i++){
					Long id = awardIds.get(i);
					if(null != id && oaoIds.contains(id)){
						oaoIds.remove(id);
					}
				}
				//批量删除 题目
				if(!oaoIds.isEmpty()){
					developQuestionRecordDao.updateRecordDeleteStatus(oaoIds);
				}
			}
		}
		
		//判断奖项是否有更新或新增项
		for(int i=0;i<questionRecord.length;i++){
			JSONObject jsonOption = JSONObject.parseObject(questionRecord[i]);
			QuestionRecordEntity recordDto =new QuestionRecordEntity(true);
			if(null != jsonOption.getLong("id")){
				recordDto =new QuestionRecordEntity(jsonOption.getLong("id"));
			}

			//活动id
			recordDto.setOperatingActivityId(activityId);
			//题目名称
			recordDto.setName(jsonOption.getString("name"));
			//正确答案（序号1-6）
			recordDto.setRightAnswer(jsonOption.getInteger("rightAnswer"));
			//选项1
			recordDto.setOption1(jsonOption.getString("option1"));
			//选项2
			recordDto.setOption2(jsonOption.getString("option2"));
			//选项3
			recordDto.setOption3(jsonOption.getString("option3"));
			//选项4
			recordDto.setOption4(jsonOption.getString("option4"));
			//选项5
			recordDto.setOption5(jsonOption.getString("option5"));
			//选项6
			recordDto.setOption6(jsonOption.getString("option6"));
			//类型（image图片，text文字）
			recordDto.setType(jsonOption.getString("type"));
			//题目数
			recordDto.setOptionNum(optionNum);

			if(null == recordDto.getId()){
				developQuestionRecordDao.insertRecord(recordDto);
			}else{
				developQuestionRecordDao.updateRecord(recordDto);
			}
		}
	}

}
