package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersDao;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessOrdersServiceImpl implements GuessOrdersService {
    
    @Autowired
    private GuessOrdersDao guessOrdersDao;

    @Override
    public List<GuessOrdersDto> findWinByGuessIdAndPrizeId(Long duibaGuessId, Long prizeId) {
        return BeanUtils.copyList(guessOrdersDao.findWinByGuessIdAndPrizeId(duibaGuessId,prizeId),GuessOrdersDto.class);
    }

    /**
     * 精确匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param winIds
     * @param guessData    @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData) {
        return BeanUtils.copyList(guessOrdersDao.findWinOrderByExactMatch(duibaGuessId,winIds,guessData),GuessOrdersDto.class);
    }

    /**
     * 模糊匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData    @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData) {
        return BeanUtils.copyList(guessOrdersDao.findWinOrderByVagueMatch(duibaGuessId,num,luckNum,guessData),GuessOrdersDto.class);
    }

    @Override
    public List<GuessOrdersDto> findExpireOrder() {
        return BeanUtils.copyList(guessOrdersDao.findExpireOrder(),GuessOrdersDto.class);
    }

    /**
     * 精确匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId   @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData, Integer offset, Integer max, Long consumerId) {
        return BeanUtils.copyList(guessOrdersDao.findWinOrderByExactMatch(duibaGuessId,winIds,guessData,offset,max,consumerId),GuessOrdersDto.class);
    }

    /**
     * 模糊匹配获取中奖名单
     *
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId   @return
     */
    @Override
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData, Integer offset, Integer max, Long consumerId) {
        return BeanUtils.copyList(guessOrdersDao.findWinOrderByVagueMatch(duibaGuessId,num,luckNum,guessData,offset,max,consumerId),GuessOrdersDto.class);
    }
}
