package cn.com.duiba.activity.center.biz.dao.datasource;

import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class ReadOnlyDataSource extends AbstractRoutingDataSource {

	private static final ThreadLocal<String> readOnlyDataSourceContext = new ThreadLocal<String>();

	public static void setReadDataSource(String dataSource) {
		ReadOnlyDataSource.readOnlyDataSourceContext.set(dataSource);
	}

	public static void clearReadDataSource() {
		ReadOnlyDataSource.readOnlyDataSourceContext.remove();
	}

	@Override
	protected Object determineCurrentLookupKey() {
		return ReadOnlyDataSource.readOnlyDataSourceContext.get();
	}

}
