package cn.com.duiba.activity.center.biz.dao.readwrite;

import org.mybatis.spring.SqlSessionTemplate;

/**
 * 是否支持读写分离
 * @author xuhengfei
 *
 */
public interface ReadWaySupport {
	/**
	 * 能否走读库通道
	 * @return
	 */
	public boolean canGoReadWay();
	/**
	 * 获取读库的SqlSession
	 * @return
	 */
	public SqlSessionTemplate getReadWaySqlSession();
	/**
	 * 智能获取select查询的sqlsession
	 * 如果标记可以走读库，会返回读库的sqlSession
	 * 如果没有标记走读库，还是会返回主库的sqlSession
	 * @return
	 */
	public SqlSessionTemplate getSelectRouteSqlSession();
}
