/**
 * Project Name:activity-center-biz
 * File Name:TodayRobConfigDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.rob
 * Date:2016年7月25日下午3:08:49
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.rob;
import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;

/**
 * ClassName:TodayRobConfigDao <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午3:08:49 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface TodayRobConfigDao {

    /**
     * 根据id查询
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public TodayRobConfigDto find(Long configId);
    
    /**
     * 新增
     * @author zp
     * @param todayRobConfigDto
     * @return
     * @since JDK 1.6
     */
    public Long insert(TodayRobConfigDto todayRobConfigDto);
   
    /**
     * 编辑/保存
     * @author zp
     * @param todayRobConfigDto
     * @return
     * @since JDK 1.6
     */
    public Long update(TodayRobConfigDto todayRobConfigDto);
    
    /**
     * 分页查询
     * @author zp
     * @param params
     * @return
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String,Object> params);
    
    /**
     * 分页count
     * @author zp
     * @param params
     * @return
     * @since JDK 1.6
     */
    public Integer findTodayRobConfigCount(Map<String,Object> params);
    
    /**
     * 删除活动
     * @author zp
     * @param configId
     * @return
     * @since JDK 1.6
     */
    public Boolean del(Long configId);
    
    /**
     * 状态改变
     * @author zp
     * @param configId
     * @param status
     * @return
     * @since JDK 1.6
     */
    public Boolean statusChange(Long configId,Integer status);
    
    /**
     * 排序包括置顶
     * @author zp
     * @param offset
     * @param pageSize
     * @return
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset,Integer pageSize);
    
    /**
     * 更新置顶
     * @author zp
     * @param id
     * @param switches
     * @param stickyTime
     * @return
     * @since JDK 1.6
     */
    public Boolean updateStickyTime(Long id,Integer switches,Date stickyTime);
    
    /**
     * 更新参与次数
     * @author zp
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Boolean updateVisitTime(Long id);

    /**
     * 取消全部已经置顶的今日必抢活动
     * @author sunchangji
     * @return
     * @since JDK 1.7
     */
    Boolean updateAllTopSwitches();
}

