/**
 * Project Name:activity-center-biz File Name:MyJob.java Package Name:cn.com.duiba.activity.center.biz.job
 * Date:2016年9月28日下午4:16:49 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.job;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.activity.center.common.util.AppLogUtil;
import cn.com.duiba.activity.center.common.util.DateUtil;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;

/**
 * ClassName:MyJob <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年9月28日 下午4:16:49 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class TodayRobSeckillStopJob extends AbstractSimpleElasticJob {

    private static Logger log = LoggerFactory.getLogger(TodayRobSeckillStopJob.class);
    
    @Autowired
    private TodayRobSeckillService todayRobSeckillService;

    @Override
    public void process(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn(log, "################# 今日必抢秒杀免单定时任务-停用前一天的秒杀区间，开始执行 #################");
        todayRobSeckillService.disableActivityBeforeDate(DateUtil.getDayDate(new Date()));
        AppLogUtil.warn(log, "################# 今日必抢秒杀免单定时任务-停用前一天的秒杀区间，执行结束 #################");
    }
    
}
