package cn.com.duiba.activity.center.biz.plugin.event;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;

public interface DuibaEvent<X> {

	public X getData();
	
	public static class RequestParams{
		private String userAgent;
		private Long consumerId;
		private String ip;
		private Map<String, String> cookies = new HashMap<String, String>();
		public String getUserAgent() {
			return userAgent;
		}
		public void setUserAgent(String userAgent) {
			this.userAgent = userAgent;
		}
		public Long getConsumerId() {
			return consumerId;
		}
		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}
		public String getIp() {
			return ip;
		}
		public void setIp(String ip) {
			this.ip = ip;
		}
		public String getCookies(String name) {
			return this.cookies.get(name);
		}
		public void setCookies(HttpServletRequest request) {
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (int i = 0; i < cookies.length; i++) {
					Cookie c = cookies[i];
					this.cookies.put(c.getName(), c.getValue());
				}
			}
		}
		public static RequestParams parse(HttpServletRequest request,Long consumerId){
			RequestParams rp=new RequestParams();
			rp.setUserAgent(request.getHeader("User-Agent"));
			rp.setIp(RequestTool.getIpAddr(request));
			rp.setConsumerId(consumerId);
			rp.setCookies(request);
			return rp;
		}
		public Map<String, String> getCookies() {
			return cookies;
		}
		public void setCookies(Map<String, String> cookies) {
			this.cookies = cookies;
		}
	}
	
	
	
}
