/**
 * Project Name:activity-center-biz
 * File Name:RemoteAddCreditExceptionServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame
 * Date:2016年9月20日下午5:08:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.AddCreditExceptionRecordDto;
import cn.com.duiba.activity.center.api.dto.creditgame.QueryParameters;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteAddCreditExceptionService;
import cn.com.duiba.activity.center.biz.entity.creditgame.AddCreditExceptionRecordEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.AddCreditExceptionRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteAddCreditExceptionServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Date:     2016年9月20日 下午5:08:05 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteAddCreditExceptionServiceImpl implements RemoteAddCreditExceptionService{

    @Resource
    private AddCreditExceptionRecordService addCreditExceptionRecordService;
    
    private static Logger log = LoggerFactory.getLogger(RemoteAddCreditExceptionServiceImpl.class);
    @Override
    public DubboResult<Boolean> add(AddCreditExceptionRecordDto dto) {
        try{
            AddCreditExceptionRecordEntity entity = new AddCreditExceptionRecordEntity();
            ObjectUtil.convert(dto,entity);
            int recorde = this.addCreditExceptionRecordService.insert(entity);
            if(recorde == 1){
                return DubboResult.successResult(Boolean.TRUE);
            }else{
                return DubboResult.failResult("");
            }
        } catch (Exception e){
            log.error("加积分异常记录添加出错",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PaginationDto<AddCreditExceptionRecordDto>> findPage(QueryParameters params,
                                                                                  PagingParameters pageparams) {
        try{
            PaginationDto<AddCreditExceptionRecordDto> rs = new PaginationDto<AddCreditExceptionRecordDto>();
            Integer offset =pageparams.getOffset();
            Integer max = pageparams.getMax();
            String orderNum = params.getOrderNum();
            List<Long> appIds = params.getAppIds();
            Byte exceptionType =params.getExceptionType();
            Date start = params.getStart();
            Date end = params.getEnd();
            if(StringUtils.isBlank(orderNum)){
                orderNum = null;
            }
            if(CollectionUtils.isEmpty(appIds)){
                appIds = null;
            }
            
            Long count = this.addCreditExceptionRecordService.findCount(orderNum, appIds, exceptionType, start, end);
            List<AddCreditExceptionRecordDto> dtos = Lists.newArrayList();
            if(count!=null&&count>0){
                List<AddCreditExceptionRecordEntity> entitys = this.addCreditExceptionRecordService.findPage(orderNum, appIds, exceptionType, start, end, offset, max);
                ObjectUtil.convertList(entitys, dtos, AddCreditExceptionRecordDto.class);
            }else{
                count = 0L;
            }
            rs.setRows(dtos);
            rs.setTotalCount(count);
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("加积分记录查询出错",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
}


