/**
 * Project Name:activity-center-biz File Name:RemoteCreditGameBackendServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame Date:2016年9月7日下午6:10:21 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;


import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.creditgame.QueryParameters;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameBackendService;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteCreditGameBackendServiceImpl <br/>
 * Date: 2016年9月7日 下午6:10:21 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteCreditGameBackendServiceImpl implements RemoteCreditGameBackendService {

    @Resource
    private CreditGameService creditGameService;
    @Resource
    private OperatingActivityService operatingActivityService;

    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameBackendServiceImpl.class);

    @Override
    public DubboResult<Long> addCreditGame(CreditGameDto dto) {
        try {
            CreditGameEntity entity = new CreditGameEntity();
            ObjectUtil.convert(dto, entity);
            this.creditGameService.insert(entity);
            return DubboResult.successResult(entity.getId());
        } catch (Exception e) {
            log.error("RemoteCreditGameBackendService.addCreditGame error", e);
            return DubboResult.failResult(e.getMessage());
        }

    }

    @Override
    public DubboResult<Boolean> updateCreditGame(Long id, CreditGameDto dto) {
        try {
            CreditGameEntity entity = new CreditGameEntity();
            ObjectUtil.convert(dto, entity);
            int i = this.creditGameService.update(entity);
            if(i==1){
                return DubboResult.successResult(true);
            } else{
                return DubboResult.failResult("更新记录为"+i);
            }
        } catch (Exception e) {
            log.error("RemoteCreditGameBackendService.updateCreditGame error,id="+id,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<CreditGameDto> getCreditGameByCreditGameId(Long id) {
        try{
            CreditGameEntity entity = this.creditGameService.getCreditGameById(id);
            CreditGameDto dto = new CreditGameDto();
            ObjectUtil.convert(entity, dto);
            return DubboResult.successResult(dto);
        } catch (Exception e){
            log.error("RemoteCreditGameBackendService.getCreditGameByCreditGameId("+id+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<CreditGameDto>> getGamesByQueryParameters(QueryParameters queryParameters) {
        try{
            return DubboResult.successResult(null);
        } catch (Exception e){
            log.error("RemoteCreditGameBackendService.getCreditGameByCreditGameId() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PaginationDto<CreditGameDto>> getCreditGamesByQueryAndPagingParameters(String title,
                                                                                              PagingParameters pagingParameters) {
        try{
            PaginationDto<CreditGameDto> rs = new PaginationDto<CreditGameDto>();
            List<CreditGameDto> dtos = Lists.newArrayList();
            Long total = this.creditGameService.findCount(title);
            if(total>0){
                List<CreditGameEntity> entitys = this.creditGameService.findPage(title, pagingParameters.getOffset(), pagingParameters.getMax());
                if(CollectionUtils.isNotEmpty(entitys)){
                    ObjectUtil.convertList(entitys, dtos, CreditGameDto.class);
                }else{
                    log.error("creditGameService.findPage 查询异常，creditGameService.findCount 结果为"+total);
                }
                rs.setRows(dtos);
                rs.setTotalCount(total);
            }else{
                rs.setRows(dtos);
                rs.setTotalCount(0L);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("RemoteCreditGameBackendService.getCreditGamesByQueryAndPagingParameters() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteCreditGame(Long id) {
        try{
            this.creditGameService.delete(id);
            return DubboResult.successResult(Boolean.TRUE);
        } catch (Exception e){
            log.error("RemoteCreditGameBackendService.deleteCreditGame("+id+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> autoOff() {
        try{
            log.error("----积分游戏开始执行自动下架定时任务----");
            int ret = 0;
            List<Long> activityIds = this.creditGameService.findAutoOff();
            if(CollectionUtils.isNotEmpty(activityIds)){
                for (Long activityId : activityIds) {
                    this.updateStatusCloseShow(activityId);
                    ret = ret + 1;
                }
            }
            log.error("----积分游戏定时任务执行结束----");
            return DubboResult.successResult(ret);
        } catch (Exception e){
            log.error("RemoteCreditGameBackendService.autoOff() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    /**
     * 关闭并可见
     */
    public void updateStatusCloseShow(Long activityId) {
        int ret = this.creditGameService.updateStatus(activityId,CreditGameDto.STATUS_CLOSE_SHOW);
        if (ret > 0) {
            try {
                operatingActivityService.updateStatusByActivityIdAndType(activityId, OperatingActivityDto.TypeDuibaCreditGame, OperatingActivityDto.StatusIntClose);
            } catch (Exception e) {
                log.error("updateStatusCloseShow", e);
            }
        }
    }
    

}
