package cn.com.duiba.activity.center.biz.remoteservice.impl.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.guess.RemoteGuessOrdersSimpleService;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersSimpleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class RemoteGuessOrdersSimpleServiceImpl implements RemoteGuessOrdersSimpleService {

    @Autowired
    private GuessOrdersSimpleService guessOrdersSimpleService;

    @Override
    public GuessOrdersDto find(Long consumerId, Long guessOrderId) {
        return guessOrdersSimpleService.find(consumerId,guessOrderId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return guessOrdersSimpleService.countByConsumerIdAndOperatingActivityId(consumerId,operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return guessOrdersSimpleService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId,operatingActivityId,start,end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long id, Date start, Date end) {
        return guessOrdersSimpleService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId,id,start,end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long id) {
        return guessOrdersSimpleService.countFreeByConsumerIdAndOperatingActivityId(consumerId,id);
    }

    @Override
    public List<GuessOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return guessOrdersSimpleService.findByIds(consumerId,ids);
    }

    @Override
    public List<GuessOrdersDto> findWinOrders(Long consumerId, Long duibaGuessId) {
        return guessOrdersSimpleService.findWinOrders(consumerId,duibaGuessId);
    }

    @Override
    public List<GuessOrdersDto> findGuessOrders(Long consumerId, Long duibaGuessId) {
        return guessOrdersSimpleService.findGuessOrders(consumerId,duibaGuessId);
    }
}
