package cn.com.duiba.activity.center.biz.remoteservice.impl.rob;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillListDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.RemoteTodayRobSeckillBackendService;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.biz.domain.PushAppsConfig;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * RemoteTodayRobSeckillBackendService <br/>
 * Function: 今日必抢的免单秒杀 <br/>
 * Date: 2016年9月30日 上午8:53:28 <br/>
 * 
 * @author zhengjy
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteTodayRobSeckillBackendServiceImpl implements RemoteTodayRobSeckillBackendService {

    Logger                         log = LoggerFactory.getLogger(RemoteTodayRobSeckillBackendServiceImpl.class);

    @Autowired
    private TodayRobSeckillService todayRobSeckillService;
    @Autowired
    private TodayRobSeckillBo      todayRobSeckillBo;
    @Autowired
    private CenterConfigService    centerConfigService;

    @Override
    public DubboResult<List<TodayRobSeckillConfigDto>> findSeckillConfigs(Long todayRobSeckillId) {
        try {
            List<TodayRobSeckillConfigDto> list = new ArrayList<TodayRobSeckillConfigDto>();
            List<TodayRobSeckillConfigEntity> ret = todayRobSeckillService.findSeckillConfigs(todayRobSeckillId);
            ObjectUtil.convertList(ret, list, TodayRobSeckillConfigDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("todayRobSeckillId=" + todayRobSeckillId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<TodayRobSeckillDto> findSeckillById(Long todayRobSeckillId) {
        try {
            TodayRobSeckillDto trd = new TodayRobSeckillDto();
            TodayRobSeckillEntity trs = todayRobSeckillService.findSeckillById(todayRobSeckillId);
            ObjectUtil.convert(trs, trd);
            return DubboResult.successResult(trd);
        } catch (Exception e) {
            log.error("todayRobSeckillId=" + todayRobSeckillId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> seveSeckillConfigs(List<TodayRobSeckillConfigDto> list,
                                                   TodayRobSeckillDto todayRobSeckillDto) {

        try {
            return DubboResult.successResult(todayRobSeckillBo.seveSeckillConfigs(list, todayRobSeckillDto));
        } catch (Exception e) {
            log.error("", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<PaginationDto<TodayRobSeckillListDto>> findTodayRobSeckillList(int pageNum, int pageSize) {
        try {

            return DubboResult.successResult(todayRobSeckillBo.findTodayRobSeckillList(pageNum, pageSize));
        } catch (Exception e) {
            log.error("", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delTodayRobSeckill(long todayRobSeckillId) {
        try {
            return DubboResult.successResult(todayRobSeckillService.delTodayRobSeckill(todayRobSeckillId));
        } catch (Exception e) {
            log.error("todayRobSeckillId=" + todayRobSeckillId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> enableTodayRobSeckill(long todayRobSeckillId, boolean enable) {
        try {
            return DubboResult.successResult(todayRobSeckillBo.enableTodayRobSeckill(todayRobSeckillId, enable));
        } catch (Exception e) {
            log.error("todayRobSeckillId=" + todayRobSeckillId + ",enable=" + enable, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> updatePushApps(List<Long> appIdList) {
        try {
            CenterConfigEntity centerConfigEntity = centerConfigService.findPushAppsConfig();
            PushAppsConfig pushAppsConfig = new PushAppsConfig(centerConfigEntity);
            List<Long> existAppIdList = pushAppsConfig.getAppIdList();
            // List<Long> toUpdateAppIdList = Lists.newArrayList(appIdList);
             centerConfigService.updatePushAppsConfig(appIdList);
            appIdList.removeAll(existAppIdList);
            List<Long> todayRobSeckillIds = todayRobSeckillService.findEnableTodayRobSeckillIds();
            List<TodayRobSeckillConfigEntity> list = todayRobSeckillService.findSeckillConfigByIdss(todayRobSeckillIds);
            todayRobSeckillBo.pushSeckillActivity(BeanUtils.copyList(list, TodayRobSeckillConfigDto.class), appIdList);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            log.error("appIdList=" + appIdList, e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
