/**
 * Project Name:activity-center-biz File Name:RemoteTodayRobSeckillServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.rob Date:2016年10月9日下午1:53:29 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.rob;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillAppDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.RemoteTodayRobSeckillService;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.common.util.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteTodayRobSeckillServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月9日 下午1:53:29 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteTodayRobSeckillServiceImpl implements RemoteTodayRobSeckillService {

    private static Logger     log = LoggerFactory.getLogger(RemoteTodayRobSeckillServiceImpl.class);
    @Autowired
    private TodayRobSeckillBo todayRobSeckillBo;

    @Override
    public DubboResult<List<TodayRobSeckillAppDto>> findSeckillListByApp(Long appId) {
        try {
            List<TodayRobSeckillAppDto> list = todayRobSeckillBo.findSeckillListByApp(appId);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke RemoteTodayRobSeckillService.findSeckillListByApp failed, appId={}", appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
