package cn.com.duiba.activity.center.biz.service;


import cn.com.duiba.activity.center.biz.dao.GenericCURDDao;

/**
 * CRUD BO 抽象基类
 *
 * @author jyc
 * @since 2016-09-05
 */
public abstract class AbstractGenericCURDService<E, PK> implements GenericCURDService<E, PK> {

    @Override
    public E queryById(PK id) {
        return getDao().queryById(id);
    }

    @Override
    public int delete(PK id) {
        return getDao().delete(id);
    }

    @Override
    public int insert(E record) {
        return getDao().insert(record);
    }

    @Override
    public int update(E record) {
        return getDao().update(record);
    }

    protected abstract GenericCURDDao<E, PK> getDao();
}
