package cn.com.duiba.activity.center.biz.service.creditgame.impl;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.biz.dao.GenericCURDDao;
import cn.com.duiba.activity.center.biz.dao.creditgame.AddCreditExceptionRecordDao;
import cn.com.duiba.activity.center.biz.entity.creditgame.AddCreditExceptionRecordEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.AddCreditExceptionRecordService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.AbstractGenericCURDService;

/**
 * 加积分异常记录Service实现类
 * @author jyc
 * @since 2016-09-06
 */
@Service
public class AddCreditExceptionRecordServiceImpl extends AbstractGenericCURDService<AddCreditExceptionRecordEntity,Long> implements AddCreditExceptionRecordService {

    @Autowired
    private AddCreditExceptionRecordDao addCreditExceptionRecordDao;

    protected  GenericCURDDao<AddCreditExceptionRecordEntity, Long> getDao(){
        return addCreditExceptionRecordDao;
    }

    @Override
    public List<AddCreditExceptionRecordEntity> findPage(String orderNum, List<Long> appIds, Byte exceptionType,
                                                      Date start, Date end,int offset,int max) {
        return this.addCreditExceptionRecordDao.selectList(orderNum, appIds, exceptionType, start, end, offset, max);
    }

    @Override
    public Long findCount(String orderNum, List<Long> appIds, Byte exceptionType, Date start, Date end) {
        
        return this.addCreditExceptionRecordDao.selectCount(orderNum, appIds, exceptionType, start, end);
    }

}
