package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersExtraDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersExtraEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersExtraService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionAnswerOrdersExtraServiceImpl implements DuibaQuestionAnswerOrdersExtraService {
    @Resource
    private DuibaQuestionAnswerOrdersExtraDao duibaQuestionAnswerOrdersExtraDao;
//    @Resource
//    private CacheClient cacheClient;

    @Override
    public int insert(DuibaQuestionAnswerOrdersExtraDto duibaQuestionAnswerOrdersExtraDO) {
        DuibaQuestionAnswerOrdersExtraEntity e = BeanUtils.copy(duibaQuestionAnswerOrdersExtraDO,DuibaQuestionAnswerOrdersExtraEntity.class);
        int ret = duibaQuestionAnswerOrdersExtraDao.insert(e);
        duibaQuestionAnswerOrdersExtraDO.setId(e.getId());
        //cacheClient.remove(getCacheKeyByOrderId(e.getQuestionOrdersId()));
        return ret;
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto find(Long ordersExtraId) {
        return BeanUtils.copy(duibaQuestionAnswerOrdersExtraDao.find(ordersExtraId), DuibaQuestionAnswerOrdersExtraDto.class);
    }

    @Override
    public int update(Long ordersExtraId, String answerData, Integer rightCount) {
        DuibaQuestionAnswerOrdersExtraEntity e = duibaQuestionAnswerOrdersExtraDao.find(ordersExtraId);

        int ret = duibaQuestionAnswerOrdersExtraDao.update(ordersExtraId, answerData, rightCount);
        //cacheClient.remove(getCacheKeyByOrderId(e.getQuestionOrdersId()));
        return ret;
    }

    private String getCacheKeyByOrderId(Long questionOrderId){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_ORDERS_EXTRA_BY_ORDERID + questionOrderId;
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto findByQuestionOrderId(Long questionOrderId) {
        String key = getCacheKeyByOrderId(questionOrderId);
        DuibaQuestionAnswerOrdersExtraDto dto;// = cacheClient.get(key);
        //if(dto == null) {
            dto = BeanUtils.copy(duibaQuestionAnswerOrdersExtraDao.findByQuestionOrderId(questionOrderId), DuibaQuestionAnswerOrdersExtraDto.class);
            //cacheClient.set(key, dto, 1, TimeUnit.HOURS);
        //}
        return dto;
    }
}
