package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessSelectionsDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessSelectionsDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessSelectionsEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessSelectionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class DuibaGuessSelectionsServiceImpl implements DuibaGuessSelectionsService {

    @Autowired
    private DuibaGuessSelectionsDao duibaGuessSelectionsDao;

    @Override
    public DuibaGuessSelectionsDto find(Long id) {
        return BeanUtils.copy(duibaGuessSelectionsDao.find(id),DuibaGuessSelectionsDto.class);
    }

    @Override
    public void insert(DuibaGuessSelectionsDto duibaGuessSelections) {
        DuibaGuessSelectionsEntity entity=BeanUtils.copy(duibaGuessSelections,DuibaGuessSelectionsEntity.class);
        duibaGuessSelectionsDao.insert(entity);
        duibaGuessSelections.setId(entity.getId());
    }

    @Override
    public void update4Admin(Long id, Long duibaGuessId, Integer position, String content) {
        duibaGuessSelectionsDao.update4Admin(id,duibaGuessId,position,content);
    }

    @Override
    public List<DuibaGuessSelectionsDto> findAllByGuessId(Long duibaGuessId) {
        return BeanUtils.copyList(duibaGuessSelectionsDao.findAllByGuessId(duibaGuessId),DuibaGuessSelectionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaGuessSelectionsDao.delete(ids);
    }
}
