package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolStockConsumeDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolStockConsumeEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolStockConsumeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/5/20.
 */
@Service
public class HdtoolStockConsumeServiceImpl implements HdtoolStockConsumeService {
    @Resource
    private HdtoolStockConsumeDao hdtoolStockConsumeDao;

    @Override
    public int insert(HdtoolStockConsumeDto hdtoolStockConsumeDto) {
        HdtoolStockConsumeEntity e = BeanUtils.copy(hdtoolStockConsumeDto, HdtoolStockConsumeEntity.class);
        int ret = hdtoolStockConsumeDao.insert(e);
        hdtoolStockConsumeDto.setId(e.getId());
        return ret;
    }

    @Override
    public HdtoolStockConsumeDto findByBizIdAndSourcePay(String bizId, String bizSource) {
        return BeanUtils.copy(hdtoolStockConsumeDao.findByBizIdAndSourcePay(bizId, bizSource), HdtoolStockConsumeDto.class);
    }
}
