package cn.com.duiba.activity.center.biz.service.quizz.impl;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockManualChangeDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockDao;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockManualChangeEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzStockService;
import cn.com.duiba.activity.center.biz.support.copier.quizz.DuibaQuizzStockCopier;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by xuezhaoming on 16/6/7.
 */
@Service
public class QuizzStockServiceImpl implements QuizzStockService {

    private static final Logger LOG = LoggerFactory.getLogger(QuizzStockServiceImpl.class);

    @Resource
    private DuibaQuizzStockDao duibaQuizzStockDao;

    @Resource
    private DuibaQuizzStockManualChangeDao duibaQuizzStockManualChangeDao;

    @Override
    public int subStock(Long id, Integer subNumber) {
        if (id == null || id.longValue() <= 0 || subNumber == null || subNumber.longValue() <= 0) {
            return 0;
        }

        return duibaQuizzStockDao.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        if (id == null || id.longValue() <= 0 || addNumber == null || addNumber.intValue() <= 0) {
            return 0;
        }
        return duibaQuizzStockDao.addStock(id, addNumber);
    }

    @Override
    public DuibaQuizzStockDto findRemaining(Long optionId) {
        if (optionId == null || optionId.longValue() <= 0) {
            return null;
        }

        DuibaQuizzStockEntity entity = duibaQuizzStockDao.findRemaining(optionId);

        return DuibaQuizzStockCopier.entity2Dto(entity);
    }


    //manager
    @Override
    public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId) {
        return BeanUtils.copy(duibaQuizzStockDao.findByQuizzOptionId(questionOptionId), DuibaQuizzStockDto.class);
    }

    @Override
    public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list) {
        return BeanUtils.copyList(duibaQuizzStockDao.findByQuizzOptionIds(list), DuibaQuizzStockDto.class);
    }

    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        return duibaQuizzStockDao.updateStockAdd(id, stockAdd);
    }

    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        return duibaQuizzStockDao.updateStockSub(id, stockSub);
    }

    @Override
    public void add(DuibaQuizzStockDto quizzStockDO) {
        DuibaQuizzStockEntity e = BeanUtils.copy(quizzStockDO,DuibaQuizzStockEntity.class);
        duibaQuizzStockDao.add(e);
        quizzStockDO.setId(e.getId());
    }

    @Override
    public void addBatch(List<DuibaQuizzStockDto> list) {
        duibaQuizzStockDao.addBatch(BeanUtils.copyList(list,DuibaQuizzStockEntity.class));
    }


    @Transactional(DsConstants.DATABASE_QUIZZ)
    public void updateStockByOptions(DuibaQuizzOptionsDto option){
        Integer addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuizzStockEntity stockDO = duibaQuizzStockDao.findByQuizzOptionId(option.getId());
        if(stockDO == null){
            stockDO = new DuibaQuizzStockEntity();
            stockDO.setQuizzOptionId(option.getId());
            stockDO.setStock(option.getNewOptionCount());
            duibaQuizzStockDao.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuizzStockManualChangeDto.ADD;
            if(diff != 0){
                DuibaQuizzStockDto newStock = BeanUtils.copy(duibaQuizzStockDao.findByQuizzOptionId(option.getId()), DuibaQuizzStockDto.class);
                DuibaQuizzStockManualChangeEntity stockManualChangeDO = new DuibaQuizzStockManualChangeEntity();
                stockManualChangeDO.setQuizzStockId(stockDO.getId());
                stockManualChangeDO.setOptionId(option.getId());
                stockManualChangeDO.setBeforeStock(0);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                duibaQuizzStockManualChangeDao.add(stockManualChangeDO);
            }
        }
    }

    @Transactional(DsConstants.DATABASE_QUIZZ)
    public void updateStockByOptions(DuibaQuizzOptionsDto option, DuibaQuizzOptionsDto old) throws Exception {
        Integer addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuizzStockEntity stockDO = duibaQuizzStockDao.findByQuizzOptionId(option.getId());
        if(stockDO == null){
            stockDO = new DuibaQuizzStockEntity();
            stockDO.setQuizzOptionId(option.getId());
            stockDO.setStock(option.getNewOptionCount());
            duibaQuizzStockDao.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        }else{
            Integer oldStock = stockDO.getStock();
            Integer nowCount = option.getNewOptionCount();
            diff = (oldStock==null?0:oldStock) - (nowCount==null?0:nowCount);
            if(diff == 0){
                return ;
            }
            stockDO.setStock(diff);
            int result = 0;
            //sub
            if(diff > 0){
                addOrSub = DuibaQuizzStockManualChangeDto.SUB;
                result = duibaQuizzStockDao.updateStockSub(stockDO.getId(),stockDO.getStock());
                if(result!=1) {
                    LOG.error("测试题奖项库存减少错误了！");
                    throw new Exception("测试题奖项库存减少错误了！");
                }
            }else{
                //add
                addOrSub = DuibaQuizzStockManualChangeDto.ADD;
                result = duibaQuizzStockDao.updateStockAdd(stockDO.getId(),Math.abs(stockDO.getStock()));
                if(result!=1) {
                    LOG.error("测试题奖项库存增加错误了！");
                    throw new Exception("测试题奖项库存增加错误了！");
                }
            }
            //奖项数量有改变才记录
            if(diff != 0){
                DuibaQuizzStockEntity newStock = duibaQuizzStockDao.findByQuizzOptionId(option.getId());
                DuibaQuizzStockManualChangeEntity stockManualChangeDO = new DuibaQuizzStockManualChangeEntity();
                stockManualChangeDO.setQuizzStockId(stockDO.getId());
                stockManualChangeDO.setOptionId(option.getId());
                stockManualChangeDO.setBeforeStock(oldStock);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                duibaQuizzStockManualChangeDao.add(stockManualChangeDO);
            }
        }
    }
}
