package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.singlelottery.DuibaSingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.DuibaSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by yansen on 16/6/17.
 */
@Service
public class DuibaSingleLotteryServiceImpl implements DuibaSingleLotteryService{
    @Resource
    private DuibaSingleLotteryDao duibaSingleLotteryDao;

    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_DUIBA_SINGLE_LOTTERY_BY_ID + id;
    }

    @Override
    public List<DuibaSingleLotteryDto> findAutoOff() {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAutoOff(),DuibaSingleLotteryDto.class);
    }

    @Override
    public DuibaSingleLotteryDto find(final Long id) {
        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 5, TimeUnit.MINUTES, new CacheLoader<DuibaSingleLotteryDto>() {
            @Override
            public DuibaSingleLotteryDto load() {
                return BeanUtils.copy(duibaSingleLotteryDao.find(id),DuibaSingleLotteryDto.class);
            }
        });
    }
    
    @Override
    public String findTagById(Long id) {
        return duibaSingleLotteryDao.findTagById(id);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLotteryPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findSingleLotteryPage(queryMap),DuibaSingleLotteryDto.class);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLottery(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findSingleLottery(queryMap),DuibaSingleLotteryDto.class);
    }

    @Override
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap) {
        return duibaSingleLotteryDao.findSingleLotteryPageCount(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaSingleLottery(Long appId) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllDuibaSingleLottery(appId),AddActivityDto.class);
    }

    @Override
    public List<DuibaSingleLotteryDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllByIds(ids),DuibaSingleLotteryDto.class);
    }

    @Override
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap) {
        return duibaSingleLotteryDao.getCountDuibaSingleLottery(queryMap);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId),SingleLotteryAppSpecifyDto.class);
    }

    public Map<Long, SingleLotteryAppSpecifyDto> findSpecifyByDuibaSingleLotterysAndApp(List<Long> duibaSingleLotteryIds, Long appId){
        List<SingleLotteryAppSpecifyEntity> list = duibaSingleLotteryDao.findSpecifyByDuibaSingleLotterysAndApp(duibaSingleLotteryIds, appId);
        Map<Long, SingleLotteryAppSpecifyDto> map = new HashMap<>();
        for(SingleLotteryAppSpecifyEntity e : list){
            map.put(e.getDuibaSingleLotteryId(), BeanUtils.copy(e, SingleLotteryAppSpecifyDto.class));
        }

        return map;
    }

    @Override
    public List<SingleLotteryAppSpecifyDto> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllSpecifyByDuibaSingleLottery(duibaSingleLotteryId),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyById(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyById(id),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public List<Long> findHasUserdSingleIds(Long itemId) {
        return duibaSingleLotteryDao.findHasUserdSingleIds(itemId);
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public SingleLotteryAppSpecifyDto findSpecifyForupdate(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyForupdate(id),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findExtraInfoById(id),ActivityExtraInfoDto.class);
    }

    @Override
    public int updateAutoOffDate(Long id) {
        int result= duibaSingleLotteryDao.updateAutoOffDate(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public void insert(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        DuibaSingleLotteryEntity entity=new DuibaSingleLotteryEntity(true);
        BeanUtils.copy(duibaSingleLotteryDO, entity);
        duibaSingleLotteryDao.insert(entity);
        duibaSingleLotteryDO.setId(entity.getId());
    }

    @Override
    public int update(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        int result= duibaSingleLotteryDao.update(BeanUtils.copy(duibaSingleLotteryDO,DuibaSingleLotteryEntity.class));
        cacheClient.remove(getCacheKeyById(duibaSingleLotteryDO.getId()));
        return result;
    }

    @Override
    public int reduceMainItemRemaining(Long id) {
        int result= duibaSingleLotteryDao.reduceMainItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int addMainItemRemaining(Long id) {
        int result= duibaSingleLotteryDao.addMainItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int reduceInciteItemRemaining(Long id) {
        int result = duibaSingleLotteryDao.reduceInciteItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int addInciteItemRemaining(Long id) {
        int result= duibaSingleLotteryDao.addInciteItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int updateForAdminEdit(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        int result= duibaSingleLotteryDao.updateForAdminEdit(BeanUtils.copy(duibaSingleLotteryDO,DuibaSingleLotteryEntity.class));
        cacheClient.remove(getCacheKeyById(duibaSingleLotteryDO.getId()));
        return result;
    }

    @Override
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        int result= duibaSingleLotteryDao.reduceSpecifyAppRemaining(duibaSingleLotteryId, appId);
        return result;
    }

    @Override
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        int result= duibaSingleLotteryDao.addSpecifyAppRemaining(duibaSingleLotteryId, appId);
        return result;
    }

    @Override
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId) {
        int result= duibaSingleLotteryDao.addSpecifyOrderCount(duibaSingleLotteryId, appId);
        return result;
    }

    @Override
    public int deleteSpecify(Long id) {
        int result= duibaSingleLotteryDao.deleteSpecify(id);
        return result;
    }

    @Override
    public void insertAppSpecify(SingleLotteryAppSpecifyDto singleLotteryAppSpecifyDO) {
        SingleLotteryAppSpecifyEntity entity=new SingleLotteryAppSpecifyEntity(true);
        BeanUtils.copy(singleLotteryAppSpecifyDO,entity);
        duibaSingleLotteryDao.insertAppSpecify(entity);
        singleLotteryAppSpecifyDO.setId(entity.getId());
    }

    @Override
    public int updateSpecifyRemaining(Long id, Integer remaining) {
        int result= duibaSingleLotteryDao.updateSpecifyRemaining(id, remaining);
        return result;
    }
    
    @Override
    public int updateTagById(Long id, String tag) {
        int result = duibaSingleLotteryDao.updateTagById(id, tag);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining) {
        int result = duibaSingleLotteryDao.addMainItemRemainingById(id, addMainItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining) {
        int result= duibaSingleLotteryDao.subMainItemRemainingById(id, subMainItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining) {
        int result= duibaSingleLotteryDao.addInciteItemRemainingById(id, addInciteItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining) {
        int result = duibaSingleLotteryDao.subInciteItemRemainingById(id, subInciteItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public DuibaSingleLotteryDto findForupdate(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findForupdate(id),DuibaSingleLotteryDto.class);
    }
}
