/**
 * Project Name:activity-center-biz
 * File Name:ActualPriceCalService.java
 * Package Name:cn.com.duiba.activity.center.biz.tools
 * Date:2016年7月29日下午2:12:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.tools.service;

import java.math.BigDecimal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.service.domain.dataobject.CenterConfigDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.remoteservice.RemoteCenterConfigService;

/**
 * ClassName:ActualPriceCalService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月29日 下午2:12:05 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ActualPriceCalService {
    
    @Autowired
    private RemoteCenterConfigService remoteCenterConfigService;

    public Integer calculateNormalActualPrice(ItemKey key, String degree) {
        if (key.isItemMode() || key.isDuibaAppItemMode()) {
            if (key.getItemType().equals(ItemDO.TypeCoupon) || key.getItemType().equals(ItemDO.TypeObject)) {
                if (degree == null) {
                    return key.getItem().getActualPrice();
                } else {
                    throw new RuntimeException("券或者实物类商品不用传档位信息！");
                }
            }else if(key.getItem().getType().equals(ItemDO.TypePhonebill) || key.getItemType().equals(ItemDO.TypePhoneflow) || key.getItemType().equals(ItemDO.TypePhonebillDingzhi)){
                throw new RuntimeException("话费和流量商品不走这个方法！");
            }else if (key.getItemType().equals(ItemDO.TypeAlipay) || key.getItemType().equals(ItemDO.TypeQB)
                    || key.getItemType().equals(ItemDO.TypeAlipayFast) || key.getItemType().equals(ItemDO.TypeAlipayCode)) {
                if (degree == null) {
                    throw new RuntimeException("直充类商品不可以没有档位信息！");
                } else {
                    // actualPrice=degree*100*（根据商品类型计算汇率）
                    Integer price = Integer.valueOf(degree)*100;
                    Integer actualPrice=price;
                    CenterConfigDO ccDO = null;
                    if(key.getItem().getType().equals(ItemDO.TypeAlipay)){
                        ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipayRate);
                    }else if(key.getItem().getType().equals(ItemDO.TypeQB)){
                        ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeEnlianQbRate);
                    }else if(key.getItem().getType().equals(ItemDO.TypeAlipayFast)){
                        ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipayfastRate);
                    }else if(key.getItem().getType().equals(ItemDO.TypeAlipayCode)){
                        ccDO = remoteCenterConfigService.findByType(CenterConfigDO.TypeAlipaycodeRate);
                    }else{
                        throw new RuntimeException("没有此商品的费率信息！");
                    }
                    String rateString = null;
                    if (ccDO.getValue() != null) {
                        rateString = ccDO.getValue();
                    } else {
                        rateString = ccDO.getFloatValue().toString();
                    }
                    BigDecimal ret = new BigDecimal(price).multiply(new BigDecimal(rateString));
                    actualPrice=(int)Math.ceil(ret.doubleValue());
                    return actualPrice;
                }
            } else {
                throw new RuntimeException("无此商品类型！");
            }
        } else if (key.isSelfAppItemMode()) {
            if (key.getItemType().equals(ItemDO.TypeCoupon) || key.getItemType().equals(ItemDO.TypeObject)) {
                return 0;
            }else if(ItemDO.TypeVirtual.equals(key.getItemType())){
                return 0;
            }else{
                throw new RuntimeException("未知的自有商品类型！");
            }
        }else{
            throw new RuntimeException("无此模式类型！");
        }
    }
}

